/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

--
-- Definition of table `affiliatesources`
--
CREATE TABLE `affiliatesources` (
  `AffiliateSourceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Affiliate` varchar(255) NOT NULL,
  `DateAdded` datetime NOT NULL,
  PRIMARY KEY (`AffiliateSourceID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `affiliatesources`
--

/*!40000 ALTER TABLE `affiliatesources` DISABLE KEYS */;
INSERT INTO `affiliatesources` (`AffiliateSourceID`,`Affiliate`,`DateAdded`) VALUES 
 (2,'EWA','2010-03-21 10:40:21'),
 (3,'NeverBlue','2010-03-21 10:40:25'),
 (4,'PKM','2010-03-21 10:40:38'),
 (5,'Hydra','2010-03-30 11:41:30'),
 (6,'Azoogle','2010-03-30 11:41:37'),
 (7,'Copeac','2010-03-30 11:41:55');
/*!40000 ALTER TABLE `affiliatesources` ENABLE KEYS */;


--
-- Definition of table `alerts`
--
CREATE TABLE `alerts` (
  `AlertID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `AlertName` varchar(45) NOT NULL,
  `AlertValue` varchar(45) NOT NULL,
  PRIMARY KEY (`AlertID`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `alerts`
--

/*!40000 ALTER TABLE `alerts` DISABLE KEYS */;
INSERT INTO `alerts` (`AlertID`,`AlertName`,`AlertValue`) VALUES 
 (1,'alert1Views',''),
 (2,'alert1Conversion',''),
 (3,'alert2Views',''),
 (4,'alert2Clicks',''),
 (5,'alert3Views',''),
 (6,'alert3Subscribers',''),
 (7,'alert4Views',''),
 (8,'alert4SR',''),
 (9,'calert1Views',''),
 (10,'calert2Views',''),
 (11,'alert5Views',''),
 (12,'alert5CTR',''),
 (13,'alert6Views',''),
 (14,'alert6CR','');
/*!40000 ALTER TABLE `alerts` ENABLE KEYS */;


--
-- Definition of table `campaigns`
--
CREATE TABLE `campaigns` (
  `CampaignID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CampaignName` varchar(250) NOT NULL DEFAULT '',
  `CampaignTypeID` int(10) unsigned NOT NULL DEFAULT '1',
  `SourceID` varchar(100) NOT NULL DEFAULT '',
  `Source` varchar(250) NOT NULL DEFAULT '',
  `KeywordToken` varchar(100) NOT NULL DEFAULT '',
  `AppendToken` varchar(255) NOT NULL DEFAULT '',
  `OfferName` varchar(250) NOT NULL DEFAULT '',
  `OfferUrl` varchar(500) NOT NULL DEFAULT '',
  `Payout` double NOT NULL DEFAULT '0',
  `AffiliateSourceID` int(10) unsigned NOT NULL DEFAULT '1',
  `EngageSeconds` int(11) NOT NULL DEFAULT '0',
  `CreateDate` datetime NOT NULL,
  `CreateUserID` int(10) unsigned NOT NULL,
  `ModifyDate` datetime DEFAULT NULL,
  `ModifyUserID` int(10) unsigned DEFAULT NULL,
  `DeleteDate` datetime DEFAULT NULL,
  `DeleteUserID` int(10) unsigned DEFAULT NULL,
  `LastViews` int(11) NOT NULL DEFAULT '0',
  `LastViewsNew` int(11) NOT NULL DEFAULT '0',
  `LastProfit` double NOT NULL DEFAULT '0',
  `LastProfitNew` double NOT NULL DEFAULT '0',
  `LastROI` double NOT NULL DEFAULT '0',
  `LastReportUpdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `RealTimeCPV` double NOT NULL DEFAULT '0',
  `DestinationType` tinyint(4) NOT NULL DEFAULT '1',
  `TrackingType` tinyint(4) NOT NULL DEFAULT '2',
  `AssignedTo` int(11) NOT NULL DEFAULT '0',
  `CaptureEmbed` tinyint(4) NOT NULL DEFAULT '0',
  `CapturePopUp` tinyint(4) NOT NULL DEFAULT '0',
  `CaptureExitPop` tinyint(4) NOT NULL DEFAULT '0',
  `PassTarget` tinyint(4) NOT NULL DEFAULT '0',
  `PassSubId` tinyint(4) NOT NULL DEFAULT '1',
  `KeyCode` varchar(45) NOT NULL DEFAULT '',
  `SplitShare` int(11) NOT NULL DEFAULT '50',
  `ShareLanding` int(11) NOT NULL DEFAULT '0',
  `ShareOffer` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`CampaignID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `campaigns`
--

/*!40000 ALTER TABLE `campaigns` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaigns` ENABLE KEYS */;


--
-- Definition of table `campaigntypes`
--
CREATE TABLE `campaigntypes` (
  `CampaignTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CampaignType` varchar(100) NOT NULL,
  `CampaignTypeShort` varchar(100) DEFAULT NULL,
  `OrderIndex` tinyint(3) unsigned NOT NULL,
  `PageName` varchar(100) DEFAULT NULL,
  `SubTitleImage` varchar(100) DEFAULT NULL,
  `AnchorText` varchar(100) DEFAULT NULL,
  `MenuText` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`CampaignTypeID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `campaigntypes`
--

/*!40000 ALTER TABLE `campaigntypes` DISABLE KEYS */;
INSERT INTO `campaigntypes` (`CampaignTypeID`,`CampaignType`,`CampaignTypeShort`,`OrderIndex`,`PageName`,`SubTitleImage`,`AnchorText`,`MenuText`) VALUES 
 (4,'Lead Capture / Opt-In Campaign','Lead Capture',5,'lead-capture-campaign.php','lead_cap_sub_title.png','LeadCapture','Lead Capture'),
 (5,'Multiple Path Campaign','Multiple Path',3,'multiple-path-campaign.php','multiple path sub title original.png','MultiplePaths','Multiple Paths'),
 (6,'Landing Page Sequence Campaign','Landing Page Sequence',4,'landing-page-sequence-campaign.php','landing_page_sequence_campaign_title.png','LPSequence','Landing Page Sequence'),
 (7,'Multiple Option Campaign','Multiple Option',2,'multiple-cta-campaign.php','multiple_cta_campaign_title.png','MultipleCta','Multiple Options'),
 (8,'Direct Link & Landing Page Campaign','Direct Link & Landing Page',1,'direct-and-landing-campaign.php','directlink_vs_lp_sub_title.png','DirectAndLanding','Direct Link & Landing Page'),
 (9,'Email Follow-Up Campaign','Email Follow-up',6,'email-follow-up-campaign.php','email_followup_sub_title.png','EmailFollowUp','Email Follow-Up');
/*!40000 ALTER TABLE `campaigntypes` ENABLE KEYS */;


--
-- Definition of table `clicks`
--
CREATE TABLE `clicks` (
  `ClickID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `CampaignID` int(10) unsigned NOT NULL,
  `SubIdID` int(10) unsigned NOT NULL,
  `DestinationID` int(10) unsigned NOT NULL,
  `OfferID` int(10) unsigned DEFAULT NULL,
  `ViewDate` datetime DEFAULT NULL,
  `EngageDate` datetime DEFAULT NULL,
  `ClickDate` datetime DEFAULT NULL,
  `VisitDate` datetime DEFAULT NULL,
  `ConversionDate` datetime DEFAULT NULL,
  `SubscribeDate` datetime DEFAULT NULL,
  `OptEmbedDate` datetime DEFAULT NULL,
  `OptPopUpDate` datetime DEFAULT NULL,
  `OptExitPopDate` datetime DEFAULT NULL,
  `ConversionDateReport` datetime DEFAULT NULL,
  `CostReport` double DEFAULT NULL,
  `IPAddress` int(10) unsigned NOT NULL DEFAULT '2130706433',
  PRIMARY KEY (`ClickID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `clicks`
--

/*!40000 ALTER TABLE `clicks` DISABLE KEYS */;
/*!40000 ALTER TABLE `clicks` ENABLE KEYS */;


--
-- Definition of table `clickslp`
--
CREATE TABLE `clickslp` (
  `ClickID` bigint(20) unsigned NOT NULL,
  `Level` int(11) NOT NULL,
  `DestinationID` int(10) unsigned DEFAULT NULL,
  `ClickDate` datetime DEFAULT NULL,
  PRIMARY KEY (`ClickID`,`Level`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `clickslp`
--

/*!40000 ALTER TABLE `clickslp` DISABLE KEYS */;
/*!40000 ALTER TABLE `clickslp` ENABLE KEYS */;


--
-- Definition of table `columns`
--
CREATE TABLE `columns` (
  `ColumnID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ColumnName` varchar(200) NOT NULL,
  `ColumnSort` varchar(200) NOT NULL,
  `ClassName` varchar(200) NOT NULL DEFAULT '',
  `ColumnColor` varchar(10) NOT NULL DEFAULT '034CB5',
  `DecimalPlaces` smallint(6) NOT NULL DEFAULT '-1',
  `IsPercent` tinyint(1) NOT NULL DEFAULT '0',
  `IsDollar` tinyint(1) NOT NULL DEFAULT '0',
  `IsSortable` tinyint(1) NOT NULL DEFAULT '1',
  `IsFixed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ColumnID`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `columns`
--

/*!40000 ALTER TABLE `columns` DISABLE KEYS */;
INSERT INTO `columns` (`ColumnID`,`ColumnName`,`ColumnSort`,`ClassName`,`ColumnColor`,`DecimalPlaces`,`IsPercent`,`IsDollar`,`IsSortable`,`IsFixed`) VALUES 
 (1,'CampaignID','CampaignID','','034CB5',-1,0,0,0,0),
 (2,'Offer','Offer','left','034CB5',-1,0,0,1,0),
 (3,'Url','Url','left','034CB5',-1,0,0,1,0),
 (4,'Keyword','Keyword','left','034CB5',-1,0,0,1,0),
 (5,'Views','Views','','034CB5',0,0,0,1,0),
 (6,'Cost','Cost','','034CB5',2,0,1,1,0),
 (7,'CPV','CPV','','034CB5',3,0,1,1,0),
 (8,'Clicks','Clicks','','034CB5',0,0,0,1,0),
 (9,'CTR','CTR','','034CB5',2,1,0,1,0),
 (10,'CPC','CPC','','034CB5',2,0,1,1,0),
 (11,'Conversion','Conversion','','034CB5',0,0,0,1,0),
 (12,'CR','CR','','034CB5',2,1,0,1,0),
 (13,'Revenue','Revenue','','034CB5',2,0,1,1,0),
 (14,'EPV','EPV','','034CB5',3,0,1,1,0),
 (15,'PPV','PPV','','034CB5',3,0,1,1,0),
 (16,'eCPM','eCPM','','034CB5',2,0,1,1,0),
 (17,'Profit','Profit','','034CB5',2,0,1,1,0),
 (18,'ROI','ROI','','034CB5',2,1,0,1,0),
 (19,'EngageRate','EngageRate','','034CB5',2,1,0,1,0),
 (20,'TheIntervalName','TheIntervalName','left bold','034CB5',-1,0,0,0,0),
 (21,'Offer2','Offer2','left','034CB5',-1,0,0,1,0),
 (22,'Url2','Url2','left','034CB5',-1,0,0,1,0),
 (23,'CostRevenueProfit','CostRevenueProfit','','034CB5',-1,0,1,0,0),
 (24,'Sent','Sent','','034CB5',-1,0,0,1,0),
 (25,'EPS','EPS','','034CB5',2,0,1,1,0),
 (26,'Embed','Embed','','034CB5',0,0,0,0,0),
 (27,'EmbedPercent','EmbedPercent','','034CB5',2,1,0,0,0),
 (28,'Popup','Popup','','034CB5',0,0,0,0,0),
 (29,'PopupPercent','PopupPercent','','034CB5',2,1,0,0,0),
 (30,'Exit','Exit','','034CB5',0,0,0,0,0),
 (31,'ExitPercent','ExitPercent','','034CB5',2,1,0,0,0),
 (32,'DestinationID','DestinationID','','034CB5',-1,0,0,1,0),
 (33,'Email','Email','left','034CB5',-1,0,0,1,0),
 (34,'Subscribers','Subscribers','','034CB5',0,0,0,1,0),
 (35,'SR','SR','','034CB5',2,1,0,1,0),
 (36,'CPSUB','CPSUB','','034CB5',2,0,1,1,0);
/*!40000 ALTER TABLE `columns` ENABLE KEYS */;


--
-- Definition of table `columnscharts`
--
CREATE TABLE `columnscharts` (
  `ColumnID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CampaignTypeID` int(10) unsigned NOT NULL,
  `ReportTypeID` int(10) unsigned NOT NULL DEFAULT '1',
  `ColumnCaption` varchar(100) NOT NULL,
  `ColumnIndex` int(10) unsigned NOT NULL,
  `IsVisible` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`ColumnID`,`CampaignTypeID`,`ReportTypeID`) 
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `columnscharts`
--

/*!40000 ALTER TABLE `columnscharts` DISABLE KEYS */;
INSERT INTO `columnscharts` (`ColumnID`,`CampaignTypeID`,`ReportTypeID`,`ColumnCaption`,`ColumnIndex`,`IsVisible`) VALUES 
 (5,4,5,'Views',1,1),
 (5,4,7,'Views',1,1),
 (5,4,8,'Views',1,1),
 (5,5,5,'Views',1,1),
 (5,5,7,'Views',1,1),
 (5,5,8,'Views',1,1),
 (5,6,5,'Views',1,1),
 (5,6,7,'Views',1,1),
 (5,6,8,'Views',1,1),
 (5,6,11,'Visitors',5,1),
 (5,7,5,'Views',1,1),
 (5,7,7,'Views',1,1),
 (5,7,8,'Views',1,1),
 (5,8,5,'Views',1,1),
 (5,8,7,'Views',1,1),
 (5,8,8,'Views',1,1),
 (5,9,5,'Views',1,1),
 (5,9,7,'Views',1,1),
 (5,9,8,'Views',1,1),
 (8,4,5,'Clicks',3,0),
 (8,4,6,'Visitors',2,1),
 (8,5,5,'Clicks',3,0),
 (8,5,6,'Visitors',2,1),
 (8,5,7,'Clicks',2,0),
 (8,5,8,'Clicks',2,0),
 (8,6,5,'Clicks',3,0),
 (8,6,6,'Visitors',2,1),
 (8,6,7,'Clicks',2,0),
 (8,6,8,'Clicks',2,0),
 (8,7,5,'Clicks',3,0),
 (8,7,6,'Visitors',2,1),
 (8,7,7,'Clicks',2,0),
 (8,7,8,'Clicks',2,0),
 (8,8,5,'Clicks',3,0),
 (8,8,6,'Visitors',2,1),
 (8,8,7,'Clicks',2,0),
 (8,8,8,'Clicks',2,0),
 (8,9,4,'Clicks',1,1),
 (8,9,5,'Clicks',3,0),
 (8,9,6,'Visitors',1,1),
 (8,9,7,'Clicks',2,0),
 (8,9,8,'Clicks',2,0),
 (9,4,5,'CTR%',4,0),
 (9,5,5,'CTR%',4,0),
 (9,6,5,'CTR%',4,0),
 (9,6,11,'SR',13,0),
 (9,7,5,'CTR%',4,0),
 (9,8,5,'CTR%',4,0),
 (9,9,4,'CTR%',2,0),
 (9,9,5,'CTR%',4,0),
 (10,4,5,'CPC',5,0),
 (10,4,6,'CPC',3,0),
 (10,5,5,'CPC',5,0),
 (10,5,6,'CPC',3,0),
 (10,6,5,'CPC',5,0),
 (10,6,6,'CPC',3,0),
 (10,7,5,'CPC',5,0),
 (10,7,6,'CPC',3,0),
 (10,8,5,'CPC',5,0),
 (10,8,6,'CPC',3,0),
 (11,4,5,'Conversions',9,0),
 (11,4,6,'Conversions',4,0),
 (11,4,7,'Conversions',3,0),
 (11,4,8,'Conversions',3,0),
 (11,5,5,'Conversions',6,0),
 (11,5,6,'Conversions',4,0),
 (11,5,7,'Conversions',3,0),
 (11,5,8,'Conversions',3,0),
 (11,6,5,'Conversions',6,0),
 (11,6,6,'Conversions',4,0),
 (11,6,7,'Conversions',3,0),
 (11,6,8,'Conversions',3,0),
 (11,7,5,'Conversions',6,0),
 (11,7,6,'Conversions',4,0),
 (11,7,7,'Conversions',3,0),
 (11,7,8,'Conversions',3,0),
 (11,8,5,'Conversions',6,0),
 (11,8,6,'Conversions',4,0),
 (11,8,7,'Conversions',3,0),
 (11,8,8,'Conversions',3,0),
 (11,9,4,'Conversions',3,0),
 (11,9,6,'Conversions',2,0),
 (11,9,7,'Conversions',3,0),
 (11,9,8,'Conversions',3,0),
 (12,4,5,'CR%',10,0),
 (12,4,6,'CR%',6,0),
 (12,5,5,'CR%',7,0),
 (12,5,6,'CR%',6,0),
 (12,6,5,'CR%',7,0),
 (12,6,6,'CR%',6,0),
 (12,7,5,'CR%',7,0),
 (12,7,6,'CR%',6,0),
 (12,8,5,'CR%',7,0),
 (12,8,6,'CR%',6,0),
 (12,9,4,'CR%',4,0),
 (12,9,6,'CR%',3,0),
 (13,9,4,'Revenue',5,0),
 (13,9,5,'Revenue',5,0),
 (13,9,6,'Revenue',4,0),
 (13,9,7,'Revenue',6,0),
 (13,9,8,'Revenue',6,0),
 (14,4,5,'EPV',11,0),
 (14,5,5,'EPV',8,0),
 (14,5,6,'EPV',7,0),
 (14,5,7,'EPV',4,0),
 (14,5,8,'EPV',4,0),
 (14,6,5,'EPV',8,0),
 (14,6,7,'EPV',4,0),
 (14,6,8,'EPV',4,0),
 (14,7,5,'EPV',8,0),
 (14,7,6,'EPV',7,0),
 (14,7,7,'EPV',4,0),
 (14,7,8,'EPV',4,0),
 (14,8,5,'EPV',8,0),
 (14,8,6,'EPV',7,0),
 (14,8,7,'EPV',4,0),
 (14,8,8,'EPV',4,0),
 (14,9,7,'EPV',4,0),
 (14,9,8,'EPV',4,0),
 (15,4,5,'PPV',12,0),
 (15,5,5,'PPV',9,0),
 (15,5,6,'PPV',8,0),
 (15,5,7,'PPV',5,0),
 (15,5,8,'PPV',5,0),
 (15,6,5,'PPV',9,0),
 (15,6,7,'PPV',5,0),
 (15,6,8,'PPV',5,0),
 (15,7,5,'PPV',9,0),
 (15,7,6,'PPV',8,0),
 (15,7,7,'PPV',5,0),
 (15,7,8,'PPV',5,0),
 (15,8,5,'PPV',9,0),
 (15,8,6,'PPV',8,0),
 (15,8,7,'PPV',5,0),
 (15,8,8,'PPV',5,0),
 (15,9,7,'PPV',5,0),
 (15,9,8,'PPV',5,0),
 (16,5,6,'eCPM',5,0),
 (16,7,6,'eCPM',5,0),
 (16,8,6,'eCPM',5,0),
 (17,4,7,'P/L',6,0),
 (17,4,8,'P/L',6,0),
 (17,5,7,'P/L',6,0),
 (17,5,8,'P/L',6,0),
 (17,6,7,'P/L',6,0),
 (17,6,8,'P/L',6,0),
 (17,7,7,'P/L',6,0),
 (17,7,8,'P/L',6,0),
 (17,8,7,'P/L',6,0),
 (17,8,8,'P/L',6,0),
 (18,4,5,'ROI%',13,0),
 (18,4,6,'ROI%',9,0),
 (18,5,5,'ROI%',10,0),
 (18,5,6,'ROI%',9,0),
 (18,6,5,'ROI%',10,0),
 (18,6,6,'ROI%',9,0),
 (18,7,5,'ROI%',10,0),
 (18,7,6,'ROI%',9,0),
 (18,8,5,'ROI%',10,0),
 (18,8,6,'ROI%',9,0),
 (19,4,5,'Engage%',2,0),
 (19,5,5,'Engage%',2,0),
 (19,6,5,'Engage%',2,0),
 (19,7,5,'Engage%',2,0),
 (19,8,5,'Engage%',2,0),
 (19,9,5,'Engage%',2,0),
 (23,4,5,'Revenue-Cost-P/L',14,0),
 (23,4,6,'Revenue-Cost-P/L',11,0),
 (23,5,5,'Revenue-Cost-P/L',11,0),
 (23,5,6,'Revenue-Cost-P/L',11,0),
 (23,6,5,'Revenue-Cost-P/L',11,0),
 (23,6,6,'Revenue-Cost-P/L',11,0),
 (23,7,5,'Revenue-Cost-P/L',11,0),
 (23,7,6,'Revenue-Cost-P/L',11,0),
 (23,8,5,'Revenue-Cost-P/L',11,0),
 (23,8,6,'Revenue-Cost-P/L',11,0),
 (26,6,11,'Embed',6,0),
 (27,6,11,'Embed%',7,0),
 (28,6,11,'Popup',8,0),
 (29,6,11,'Popup%',9,0),
 (30,6,11,'Exit',10,0),
 (31,6,11,'Exit%',11,0),
 (34,4,5,'Subscribers',6,0),
 (34,4,7,'Subscribers',2,0),
 (34,4,8,'Subscribers',2,0),
 (34,6,11,'Subscribers',12,0),
 (35,4,5,'SR%',7,0),
 (35,4,7,'SR%',4,0),
 (35,4,8,'SR%',4,0),
 (36,4,5,'CPSUB',8,0),
 (36,4,7,'CPSUB',5,0),
 (36,4,8,'CPSUB',5,0);
/*!40000 ALTER TABLE `columnscharts` ENABLE KEYS */;


--
-- Definition of table `columnstypes`
--
CREATE TABLE `columnstypes` (
  `ColumnID` int(10) unsigned NOT NULL,
  `CampaignTypeID` int(10) unsigned NOT NULL,
  `ReportTypeID` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `ColumnCaption` varchar(200) NOT NULL,
  `ColumnIndex` int(10) unsigned NOT NULL,
  `IsVisible` tinyint(1) NOT NULL,
  `DefaultState` tinyint(1) NOT NULL,
  PRIMARY KEY (`ColumnID`,`CampaignTypeID`,`ReportTypeID`) 
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `columnstypes`
--

/*!40000 ALTER TABLE `columnstypes` DISABLE KEYS */;
INSERT INTO `columnstypes` (`ColumnID`,`CampaignTypeID`,`ReportTypeID`,`ColumnCaption`,`ColumnIndex`,`IsVisible`,`DefaultState`) VALUES 
 (1,4,1,'ID',1,1,1),
 (1,4,2,'ID',1,1,1),
 (1,4,4,'ID',1,1,1),
 (1,4,9,'ID',1,1,1),
 (1,4,10,'ID',1,1,1),
 (1,4,12,'ID',1,1,1),
 (1,5,1,'ID',1,1,1),
 (1,5,2,'ID',1,1,1),
 (1,5,3,'ID',1,1,1),
 (1,5,4,'ID',1,1,1),
 (1,5,9,'ID',1,1,1),
 (1,5,10,'ID',1,1,1),
 (1,6,1,'ID',1,1,1),
 (1,6,2,'ID',1,1,1),
 (1,6,3,'ID',1,1,1),
 (1,6,4,'ID',1,1,1),
 (1,6,9,'ID',1,1,1),
 (1,6,10,'ID',1,1,1),
 (1,6,12,'ID',1,1,1),
 (1,7,1,'ID',1,1,1),
 (1,7,2,'ID',1,1,1),
 (1,7,3,'ID',1,1,1),
 (1,7,4,'ID',1,1,1),
 (1,7,9,'ID',1,1,1),
 (1,7,10,'ID',1,1,1),
 (1,8,1,'ID',1,1,1),
 (1,8,2,'ID',1,1,1),
 (1,8,3,'ID',1,1,1),
 (1,8,4,'ID',1,1,1),
 (1,8,9,'ID',1,1,1),
 (1,8,10,'ID',1,1,1),
 (1,9,1,'ID',1,1,1),
 (1,9,2,'ID',1,1,1),
 (1,9,3,'ID',1,1,1),
 (1,9,4,'ID',1,1,1),
 (1,9,9,'ID',1,1,1),
 (1,9,10,'ID',1,1,1),
 (2,4,2,'Page',2,1,1),
 (2,4,4,'Page',2,0,0),
 (2,4,5,'Page',2,1,1),
 (2,4,6,'Offer',2,1,1),
 (2,4,9,'Name',2,1,1),
 (2,4,10,'Name',2,1,1),
 (2,4,12,'Name',2,1,1),
 (2,5,2,'Page',2,1,1),
 (2,5,3,'Offer',2,1,1),
 (2,5,4,'Page',2,0,0),
 (2,5,5,'Page',2,1,1),
 (2,5,6,'Offer',2,1,1),
 (2,5,9,'Name',2,1,1),
 (2,5,10,'Name',2,1,1),
 (2,6,2,'Page',2,1,1),
 (2,6,3,'Offer',2,1,1),
 (2,6,4,'Page',2,0,0),
 (2,6,5,'Page',2,1,1),
 (2,6,6,'Offer',2,1,1),
 (2,6,9,'Name',2,1,1),
 (2,6,10,'Name',2,1,1),
 (2,6,11,'Page',2,1,1),
 (2,6,12,'Name',2,1,1),
 (2,7,2,'Page',2,1,1),
 (2,7,3,'Offer',2,1,1),
 (2,7,4,'Page',2,0,0),
 (2,7,5,'Page',2,1,1),
 (2,7,6,'Offer',2,1,1),
 (2,7,9,'Name',2,1,1),
 (2,7,10,'Name',2,1,1),
 (2,8,2,'Page',2,1,1),
 (2,8,3,'Offer',2,1,1),
 (2,8,4,'Page',2,0,0),
 (2,8,5,'Page',2,1,1),
 (2,8,6,'Offer',2,1,1),
 (2,8,9,'Name',2,1,1),
 (2,8,10,'Name',2,1,1),
 (2,9,2,'Page',2,1,1),
 (2,9,3,'Offer',2,1,1),
 (2,9,5,'Page',3,1,1),
 (2,9,6,'Offer',3,1,1),
 (2,9,9,'Name',1,1,1),
 (2,9,10,'Name',2,1,1),
 (3,4,2,'URL',3,0,0),
 (3,4,4,'URL',3,0,0),
 (3,4,5,'URL',3,0,0),
 (3,4,6,'URL',3,0,0),
 (3,5,2,'URL',3,0,0),
 (3,5,3,'URL',3,0,0),
 (3,5,4,'URL',3,0,0),
 (3,5,5,'URL',3,0,0),
 (3,5,6,'URL',3,0,0),
 (3,6,2,'URL',3,0,0),
 (3,6,3,'URL',3,0,0),
 (3,6,4,'URL',3,0,0),
 (3,6,5,'URL',3,0,0),
 (3,6,6,'URL',3,0,0),
 (3,6,11,'URL',3,0,0),
 (3,7,2,'URL',3,0,0),
 (3,7,3,'URL',3,0,0),
 (3,7,4,'URL',3,0,0),
 (3,7,5,'URL',3,0,0),
 (3,7,6,'URL',3,0,0),
 (3,8,2,'URL',3,0,0),
 (3,8,3,'URL',3,0,0),
 (3,8,4,'URL',3,0,0),
 (3,8,5,'URL',3,0,0),
 (3,8,6,'URL',3,0,0),
 (3,9,2,'URL',3,0,0),
 (3,9,3,'URL',3,0,0),
 (3,9,5,'URL',4,0,0),
 (3,9,6,'URL',4,0,0),
 (4,4,1,'Target',4,1,1),
 (4,4,4,'Target',4,1,1),
 (4,5,1,'Target',4,1,1),
 (4,5,4,'Target',4,1,1),
 (4,6,1,'Target',4,1,1),
 (4,6,4,'Target',4,1,1),
 (4,7,1,'Target',4,1,1),
 (4,7,4,'Target',4,1,1),
 (4,8,1,'Target',4,1,1),
 (4,8,4,'Target',4,1,1),
 (5,4,1,'Views',5,1,1),
 (5,4,2,'Views',5,1,1),
 (5,4,4,'Views',5,1,1),
 (5,4,5,'Views',5,1,1),
 (5,4,7,'Views',5,1,1),
 (5,4,8,'Views',5,1,1),
 (5,4,9,'Views',5,1,1),
 (5,4,10,'Views',5,1,1),
 (5,4,12,'Visitors',5,1,1),
 (5,5,1,'Views',5,1,1),
 (5,5,2,'Views',5,1,1),
 (5,5,4,'Views',5,1,1),
 (5,5,5,'Views',5,1,1),
 (5,5,7,'Views',5,1,1),
 (5,5,8,'Views',5,1,1),
 (5,5,9,'Views',5,1,1),
 (5,5,10,'Views',5,1,1),
 (5,6,1,'Views',5,1,1),
 (5,6,2,'Views',5,1,1),
 (5,6,4,'Views',5,1,1),
 (5,6,5,'Views',5,1,1),
 (5,6,7,'Views',5,1,1),
 (5,6,8,'Views',5,1,1),
 (5,6,9,'Views',5,1,1),
 (5,6,10,'Views',5,1,1),
 (5,6,11,'Visitors',5,1,1),
 (5,6,12,'Visitors',5,1,1),
 (5,7,1,'Views',5,1,1),
 (5,7,2,'Views',5,1,1),
 (5,7,4,'Views',5,1,1),
 (5,7,5,'Views',5,1,1),
 (5,7,7,'Views',5,1,1),
 (5,7,8,'Views',5,1,1),
 (5,7,9,'Views',5,1,1),
 (5,7,10,'Views',5,1,1),
 (5,8,1,'Views',5,1,1),
 (5,8,2,'Views',5,1,1),
 (5,8,4,'Views',5,1,1),
 (5,8,5,'Views',5,1,1),
 (5,8,7,'Views',5,1,1),
 (5,8,8,'Views',5,1,1),
 (5,8,9,'Views',5,1,1),
 (5,8,10,'Views',5,1,1),
 (5,9,1,'# Sent',5,1,1),
 (5,9,2,'Views',5,1,1),
 (5,9,4,'# Sent',5,1,1),
 (5,9,5,'Views',6,1,1),
 (5,9,7,'Views',5,1,1),
 (5,9,8,'Views',5,1,1),
 (5,9,9,'# Sent',4,1,1),
 (5,9,10,'# Sent',4,1,1),
 (6,4,1,'Cost',7,1,1),
 (6,4,2,'Cost',7,1,1),
 (6,4,4,'Cost',7,1,1),
 (6,4,5,'Cost',7,1,1),
 (6,4,6,'Cost',9,1,1),
 (6,4,7,'Cost',7,1,1),
 (6,4,8,'Cost',7,1,1),
 (6,4,9,'Cost',7,1,1),
 (6,4,10,'Cost',7,1,1),
 (6,4,12,'Cost',7,1,1),
 (6,5,1,'Cost',7,1,1),
 (6,5,2,'Cost',7,1,1),
 (6,5,3,'Cost',7,1,1),
 (6,5,4,'Cost',7,1,1),
 (6,5,5,'Cost',7,1,1),
 (6,5,6,'Cost',9,1,1),
 (6,5,7,'Cost',7,1,1),
 (6,5,8,'Cost',7,1,1),
 (6,5,9,'Cost',7,1,1),
 (6,5,10,'Cost',7,1,1),
 (6,6,1,'Cost',7,1,1),
 (6,6,2,'Cost',7,1,1),
 (6,6,3,'Cost',7,1,1),
 (6,6,4,'Cost',7,1,1),
 (6,6,5,'Cost',7,1,1),
 (6,6,6,'Cost',9,1,1),
 (6,6,7,'Cost',7,1,1),
 (6,6,8,'Cost',7,1,1),
 (6,6,9,'Cost',7,1,1),
 (6,6,10,'Cost',7,1,1),
 (6,6,12,'Cost',7,1,1),
 (6,7,1,'Cost',7,1,1),
 (6,7,2,'Cost',7,1,1),
 (6,7,3,'Cost',9,1,1),
 (6,7,4,'Cost',7,1,1),
 (6,7,5,'Cost',7,1,1),
 (6,7,6,'Cost',9,1,1),
 (6,7,7,'Cost',7,1,1),
 (6,7,8,'Cost',7,1,1),
 (6,7,9,'Cost',7,1,1),
 (6,7,10,'Cost',7,1,1),
 (6,8,1,'Cost',7,1,1),
 (6,8,2,'Cost',7,1,1),
 (6,8,3,'Cost',9,1,1),
 (6,8,4,'Cost',7,1,1),
 (6,8,5,'Cost',7,1,1),
 (6,8,6,'Cost',9,1,1),
 (6,8,7,'Cost',7,1,1),
 (6,8,8,'Cost',7,1,1),
 (6,8,9,'Cost',7,1,1),
 (6,8,10,'Cost',7,1,1),
 (7,4,1,'CPV',8,1,1),
 (7,4,2,'CPV',8,1,1),
 (7,4,4,'CPV',8,1,1),
 (7,4,5,'CPV',8,1,1),
 (7,4,7,'CPV',8,1,1),
 (7,4,8,'CPV',8,1,1),
 (7,5,1,'CPV',8,1,1),
 (7,5,2,'CPV',8,1,1),
 (7,5,4,'CPV',8,1,1),
 (7,5,5,'CPV',8,1,1),
 (7,5,7,'CPV',8,1,1),
 (7,5,8,'CPV',8,1,1),
 (7,6,1,'CPV',8,1,1),
 (7,6,2,'CPV',8,1,1),
 (7,6,4,'CPV',8,1,1),
 (7,6,5,'CPV',8,1,1),
 (7,6,7,'CPV',8,1,1),
 (7,6,8,'CPV',8,1,1),
 (7,7,1,'CPV',8,1,1),
 (7,7,2,'CPV',8,1,1),
 (7,7,4,'CPV',8,1,1),
 (7,7,5,'CPV',8,1,1),
 (7,7,7,'CPV',8,1,1),
 (7,7,8,'CPV',8,1,1),
 (7,8,1,'CPV',8,1,1),
 (7,8,2,'CPV',8,1,1),
 (7,8,4,'CPV',8,1,1),
 (7,8,5,'CPV',8,1,1),
 (7,8,7,'CPV',8,1,1),
 (7,8,8,'CPV',8,1,1),
 (8,4,1,'Clicks',9,1,1),
 (8,4,5,'Clicks',9,1,1),
 (8,4,6,'Visitors',7,1,1),
 (8,4,12,'Clicks',8,1,1),
 (8,5,1,'Clicks',9,1,1),
 (8,5,2,'Clicks',9,1,1),
 (8,5,3,'Visitors',7,1,1),
 (8,5,4,'Clicks',9,1,1),
 (8,5,5,'Clicks',9,1,1),
 (8,5,6,'Visitors',7,1,1),
 (8,5,7,'Clicks',9,1,1),
 (8,5,8,'Clicks',9,1,1),
 (8,6,1,'Clicks',9,1,1),
 (8,6,2,'Clicks',9,1,1),
 (8,6,3,'Visitors',7,1,1),
 (8,6,4,'Clicks',9,1,1),
 (8,6,5,'Clicks',9,1,1),
 (8,6,6,'Visitors',7,1,1),
 (8,6,7,'Clicks',9,1,1),
 (8,6,8,'Clicks',9,1,1),
 (8,6,12,'Clicks',8,1,1),
 (8,7,1,'Clicks',9,1,1),
 (8,7,2,'Clicks',9,1,1),
 (8,7,3,'Visitors',7,1,1),
 (8,7,4,'Clicks',9,1,1),
 (8,7,5,'Clicks',9,1,1),
 (8,7,6,'Visitors',7,1,1),
 (8,7,7,'Clicks',9,1,1),
 (8,7,8,'Clicks',9,1,1),
 (8,8,1,'Clicks',9,1,1),
 (8,8,2,'Clicks',9,1,1),
 (8,8,3,'Visitors',7,1,1),
 (8,8,4,'Clicks',9,1,1),
 (8,8,5,'Clicks',9,1,1),
 (8,8,6,'Visitors',7,1,1),
 (8,8,7,'Clicks',9,1,1),
 (8,8,8,'Clicks',9,1,1),
 (8,9,1,'Clicks',9,1,1),
 (8,9,2,'Clicks',9,1,1),
 (8,9,3,'Visitors',7,1,1),
 (8,9,4,'Clicks',9,1,1),
 (8,9,5,'Clicks',10,1,1),
 (8,9,6,'Visitors',8,1,1),
 (8,9,7,'Clicks',9,1,1),
 (8,9,8,'Clicks',9,1,1),
 (8,9,9,'Clicks',9,1,1),
 (8,9,10,'Clicks',9,1,1),
 (9,4,1,'CTR',10,1,1),
 (9,4,5,'CTR',10,1,1),
 (9,4,12,'CTR',9,1,1),
 (9,5,1,'CTR',10,1,1),
 (9,5,2,'CTR',10,1,1),
 (9,5,4,'CTR',10,1,1),
 (9,5,5,'CTR',10,1,1),
 (9,5,7,'CTR',10,1,1),
 (9,5,8,'CTR',10,1,1),
 (9,6,1,'CTR',10,1,1),
 (9,6,2,'CTR',10,1,1),
 (9,6,4,'CTR',10,1,1),
 (9,6,5,'CTR',10,1,1),
 (9,6,7,'CTR',10,1,1),
 (9,6,8,'CTR',10,1,1),
 (9,6,12,'CTR',9,1,1),
 (9,7,1,'CTR',10,1,1),
 (9,7,2,'CTR',10,1,1),
 (9,7,4,'CTR',10,1,1),
 (9,7,5,'CTR',10,1,1),
 (9,7,7,'CTR',10,1,1),
 (9,7,8,'CTR',10,1,1),
 (9,8,1,'CTR',10,1,1),
 (9,8,2,'CTR',10,1,1),
 (9,8,4,'CTR',10,1,1),
 (9,8,5,'CTR',10,1,1),
 (9,8,7,'CTR',10,1,1),
 (9,8,8,'CTR',10,1,1),
 (9,9,1,'CTR',10,1,1),
 (9,9,2,'CTR',10,1,1),
 (9,9,4,'CTR',10,1,1),
 (9,9,5,'CTR',11,1,1),
 (9,9,7,'CTR',10,1,1),
 (9,9,8,'CTR',10,1,1),
 (9,9,9,'CTR',10,1,1),
 (9,9,10,'CTR',10,1,1),
 (10,4,1,'CPC',11,1,1),
 (10,4,5,'CPC',11,1,1),
 (10,4,6,'CPC',11,1,1),
 (10,5,1,'CPC',11,1,1),
 (10,5,2,'CPC',11,1,1),
 (10,5,3,'CPC',11,1,1),
 (10,5,4,'CPC',11,1,1),
 (10,5,5,'CPC',11,1,1),
 (10,5,6,'CPC',11,1,1),
 (10,5,7,'CPC',11,1,1),
 (10,5,8,'CPC',11,1,1),
 (10,6,1,'CPC',11,1,1),
 (10,6,2,'CPC',11,1,1),
 (10,6,3,'CPC',11,1,1),
 (10,6,4,'CPC',11,1,1),
 (10,6,5,'CPC',11,1,1),
 (10,6,6,'CPC',11,1,1),
 (10,6,7,'CPC',11,1,1),
 (10,6,8,'CPC',11,1,1),
 (10,7,1,'CPC',11,1,1),
 (10,7,2,'CPC',11,1,1),
 (10,7,3,'CPC',11,1,1),
 (10,7,4,'CPC',11,1,1),
 (10,7,5,'CPC',11,1,1),
 (10,7,6,'CPC',11,1,1),
 (10,7,7,'CPC',11,1,1),
 (10,7,8,'CPC',11,1,1),
 (10,8,1,'CPC',11,1,1),
 (10,8,2,'CPC',11,1,1),
 (10,8,3,'CPC',11,1,1),
 (10,8,4,'CPC',11,1,1),
 (10,8,5,'CPC',11,1,1),
 (10,8,6,'CPC',11,1,1),
 (10,8,7,'CPC',11,1,1),
 (10,8,8,'CPC',11,1,1),
 (11,4,1,'Conversions',12,1,1),
 (11,4,4,'Conversions',12,1,1),
 (11,4,5,'Conversions',12,1,1),
 (11,4,6,'Conversions',12,1,1),
 (11,4,7,'Conversions',12,1,1),
 (11,4,8,'Conversions',12,1,1),
 (11,4,12,'Conversions',11,1,1),
 (11,5,1,'Conversions',12,1,1),
 (11,5,2,'Conversions',12,1,1),
 (11,5,3,'Conversions',12,1,1),
 (11,5,4,'Conversions',12,1,1),
 (11,5,5,'Conversions',12,1,1),
 (11,5,6,'Conversions',12,1,1),
 (11,5,7,'Conversions',12,1,1),
 (11,5,8,'Conversions',12,1,1),
 (11,6,1,'Conversions',12,1,1),
 (11,6,2,'Conversions',12,1,1),
 (11,6,3,'Conversions',12,1,1),
 (11,6,4,'Conversions',12,1,1),
 (11,6,5,'Conversions',12,1,1),
 (11,6,6,'Conversions',12,1,1),
 (11,6,7,'Conversions',12,1,1),
 (11,6,8,'Conversions',12,1,1),
 (11,6,12,'Conversions',11,1,1),
 (11,7,1,'Conversions',12,1,1),
 (11,7,2,'Conversions',12,1,1),
 (11,7,3,'Conversions',12,1,1),
 (11,7,4,'Conversions',12,1,1),
 (11,7,5,'Conversions',12,1,1),
 (11,7,6,'Conversions',12,1,1),
 (11,7,7,'Conversions',12,1,1),
 (11,7,8,'Conversions',12,1,1),
 (11,8,1,'Conversions',12,1,1),
 (11,8,2,'Conversions',12,1,1),
 (11,8,3,'Conversions',12,1,1),
 (11,8,4,'Conversions',12,1,1),
 (11,8,5,'Conversions',12,1,1),
 (11,8,6,'Conversions',12,1,1),
 (11,8,7,'Conversions',12,1,1),
 (11,8,8,'Conversions',12,1,1),
 (11,9,1,'Conversions',12,1,1),
 (11,9,2,'Conversions',12,1,1),
 (11,9,3,'Conversions',12,1,1),
 (11,9,4,'Conversions',12,1,1),
 (11,9,5,'Conversions',13,1,1),
 (11,9,6,'Conversions',13,1,1),
 (11,9,7,'Conversions',12,1,1),
 (11,9,8,'Conversions',12,1,1),
 (11,9,9,'Conversions',12,1,1),
 (11,9,10,'Conversions',12,1,1),
 (12,4,1,'CR',13,1,1),
 (12,4,4,'CR',13,1,1),
 (12,4,5,'CR',13,1,1),
 (12,4,6,'CR',13,1,1),
 (12,4,7,'CR',13,1,1),
 (12,4,8,'CR',13,1,1),
 (12,4,12,'CR',12,1,1),
 (12,5,1,'CR',13,1,1),
 (12,5,2,'CR',13,1,1),
 (12,5,3,'CR',13,1,1),
 (12,5,4,'CR',13,1,1),
 (12,5,5,'CR',13,1,1),
 (12,5,6,'CR',13,1,1),
 (12,5,7,'CR',13,1,1),
 (12,5,8,'CR',13,1,1),
 (12,6,1,'CR',13,1,1),
 (12,6,2,'CR',13,1,1),
 (12,6,3,'CR',13,1,1),
 (12,6,4,'CR',13,1,1),
 (12,6,5,'CR',13,1,1),
 (12,6,6,'CR',13,1,1),
 (12,6,7,'CR',13,1,1),
 (12,6,8,'CR',13,1,1),
 (12,6,12,'CR',12,1,1),
 (12,7,1,'CR',13,1,1),
 (12,7,2,'CR',13,1,1),
 (12,7,3,'CR',13,1,1),
 (12,7,4,'CR',13,1,1),
 (12,7,5,'CR',13,1,1),
 (12,7,6,'CR',13,1,1),
 (12,7,7,'CR',13,1,1),
 (12,7,8,'CR',13,1,1),
 (12,8,1,'CR',13,1,1),
 (12,8,2,'CR',13,1,1),
 (12,8,3,'CR',13,1,1),
 (12,8,4,'CR',13,1,1),
 (12,8,5,'CR',13,1,1),
 (12,8,6,'CR',13,1,1),
 (12,8,7,'CR',13,1,1),
 (12,8,8,'CR',13,1,1),
 (12,9,1,'CR',13,1,1),
 (12,9,2,'CR',13,1,1),
 (12,9,3,'CR',13,1,1),
 (12,9,4,'CR',13,1,1),
 (12,9,5,'CR',14,1,1),
 (12,9,6,'CR',14,1,1),
 (12,9,7,'CR',13,1,1),
 (12,9,8,'CR',13,1,1),
 (12,9,9,'CR',13,1,1),
 (12,9,10,'CR',13,1,1),
 (13,4,1,'Revenue',14,1,1),
 (13,4,4,'Revenue',16,1,1),
 (13,4,5,'Revenue',16,1,1),
 (13,4,6,'Revenue',14,1,1),
 (13,4,7,'Revenue',14,1,1),
 (13,4,8,'Revenue',14,1,1),
 (13,4,9,'Revenue',14,1,1),
 (13,4,10,'Revenue',8,1,1),
 (13,4,12,'Revenue',13,1,1),
 (13,5,1,'Revenue',14,1,1),
 (13,5,2,'Revenue',14,1,1),
 (13,5,3,'Revenue',14,1,1),
 (13,5,4,'Revenue',16,1,1),
 (13,5,5,'Revenue',16,1,1),
 (13,5,6,'Revenue',14,1,1),
 (13,5,7,'Revenue',14,1,1),
 (13,5,8,'Revenue',14,1,1),
 (13,5,9,'Revenue',14,1,1),
 (13,5,10,'Revenue',14,1,1),
 (13,6,1,'Revenue',14,1,1),
 (13,6,2,'Revenue',14,1,1),
 (13,6,3,'Revenue',14,1,1),
 (13,6,4,'Revenue',16,1,1),
 (13,6,5,'Revenue',16,1,1),
 (13,6,6,'Revenue',14,1,1),
 (13,6,7,'Revenue',14,1,1),
 (13,6,8,'Revenue',14,1,1),
 (13,6,9,'Revenue',14,1,1),
 (13,6,10,'Revenue',14,1,1),
 (13,6,12,'Revenue',13,1,1),
 (13,7,1,'Revenue',14,1,1),
 (13,7,2,'Revenue',14,1,1),
 (13,7,3,'Revenue',14,1,1),
 (13,7,4,'Revenue',16,1,1),
 (13,7,5,'Revenue',16,1,1),
 (13,7,6,'Revenue',14,1,1),
 (13,7,7,'Revenue',14,1,1),
 (13,7,8,'Revenue',14,1,1),
 (13,7,9,'Revenue',14,1,1),
 (13,7,10,'Revenue',14,1,1),
 (13,8,1,'Revenue',14,1,1),
 (13,8,2,'Revenue',14,1,1),
 (13,8,3,'Revenue',14,1,1),
 (13,8,4,'Revenue',16,1,1),
 (13,8,5,'Revenue',16,1,1),
 (13,8,6,'Revenue',14,1,1),
 (13,8,7,'Revenue',14,1,1),
 (13,8,8,'Revenue',14,1,1),
 (13,8,9,'Revenue',14,1,1),
 (13,8,10,'Revenue',14,1,1),
 (13,9,1,'Revenue',14,1,1),
 (13,9,2,'Revenue',14,1,1),
 (13,9,3,'Revenue',14,1,1),
 (13,9,4,'Revenue',16,1,1),
 (13,9,5,'Revenue',17,1,1),
 (13,9,6,'Revenue',15,1,1),
 (13,9,7,'Revenue',14,1,1),
 (13,9,8,'Revenue',14,1,1),
 (13,9,9,'Revenue',14,1,1),
 (13,9,10,'Revenue',14,1,1),
 (14,4,1,'EPV',15,1,1),
 (14,4,4,'EPV',17,1,1),
 (14,4,5,'EPV',17,1,1),
 (14,4,7,'EPV',15,1,1),
 (14,4,8,'EPV',15,1,1),
 (14,4,9,'EPV',15,1,1),
 (14,5,1,'EPV',15,1,1),
 (14,5,2,'EPV',15,1,1),
 (14,5,3,'EPV',15,1,1),
 (14,5,4,'EPV',17,1,1),
 (14,5,5,'EPV',17,1,1),
 (14,5,7,'EPV',15,1,1),
 (14,5,8,'EPV',15,1,1),
 (14,5,9,'EPV',15,1,1),
 (14,5,10,'EPV',15,1,1),
 (14,6,1,'EPV',15,1,1),
 (14,6,2,'EPV',15,1,1),
 (14,6,3,'EPV',15,1,1),
 (14,6,4,'EPV',17,1,1),
 (14,6,5,'EPV',17,1,1),
 (14,6,7,'EPV',15,1,1),
 (14,6,8,'EPV',15,1,1),
 (14,6,9,'EPV',15,1,1),
 (14,6,10,'EPV',15,1,1),
 (14,7,1,'EPV',15,1,1),
 (14,7,2,'EPV',15,1,1),
 (14,7,3,'EPV',15,1,1),
 (14,7,4,'EPV',17,1,1),
 (14,7,5,'EPV',17,1,1),
 (14,7,7,'EPV',15,1,1),
 (14,7,8,'EPV',15,1,1),
 (14,7,9,'EPV',15,1,1),
 (14,7,10,'EPV',15,1,1),
 (14,8,1,'EPV',15,1,1),
 (14,8,2,'EPV',15,1,1),
 (14,8,3,'EPV',15,1,1),
 (14,8,4,'EPV',17,1,1),
 (14,8,5,'EPV',17,1,1),
 (14,8,7,'EPV',15,1,1),
 (14,8,8,'EPV',15,1,1),
 (14,8,9,'EPV',15,1,1),
 (14,8,10,'EPV',15,1,1),
 (15,4,1,'PPV',16,1,1),
 (15,4,4,'PPV',18,1,1),
 (15,4,5,'PPV',18,1,1),
 (15,4,7,'PPV',16,1,1),
 (15,4,8,'PPV',16,1,1),
 (15,4,9,'PPV',16,1,1),
 (15,5,1,'PPV',16,1,1),
 (15,5,2,'PPV',16,1,1),
 (15,5,3,'PPV',16,1,1),
 (15,5,4,'PPV',18,1,1),
 (15,5,5,'PPV',18,1,1),
 (15,5,7,'PPV',16,1,1),
 (15,5,8,'PPV',16,1,1),
 (15,5,9,'PPV',16,1,1),
 (15,5,10,'PPV',16,1,1),
 (15,6,1,'PPV',16,1,1),
 (15,6,2,'PPV',16,1,1),
 (15,6,3,'PPV',16,1,1),
 (15,6,4,'PPV',18,1,1),
 (15,6,5,'PPV',18,1,1),
 (15,6,7,'PPV',16,1,1),
 (15,6,8,'PPV',16,1,1),
 (15,6,9,'PPV',16,1,1),
 (15,6,10,'PPV',16,1,1),
 (15,7,1,'PPV',16,1,1),
 (15,7,2,'PPV',16,1,1),
 (15,7,3,'PPV',16,1,1),
 (15,7,4,'PPV',18,1,1),
 (15,7,5,'PPV',18,1,1),
 (15,7,7,'PPV',16,1,1),
 (15,7,8,'PPV',16,1,1),
 (15,7,9,'PPV',16,1,1),
 (15,7,10,'PPV',16,1,1),
 (15,8,1,'PPV',16,1,1),
 (15,8,2,'PPV',16,1,1),
 (15,8,3,'PPV',16,1,1),
 (15,8,4,'PPV',18,1,1),
 (15,8,5,'PPV',18,1,1),
 (15,8,7,'PPV',16,1,1),
 (15,8,8,'PPV',16,1,1),
 (15,8,9,'PPV',16,1,1),
 (15,8,10,'PPV',16,1,1),
 (16,4,1,'eCPM',18,1,1),
 (16,4,4,'eCPM',20,1,1),
 (16,4,5,'eCPM',20,1,1),
 (16,4,7,'eCPM',18,1,1),
 (16,4,8,'eCPM',18,1,1),
 (16,5,1,'eCPM',18,1,1),
 (16,5,2,'eCPM',18,1,1),
 (16,5,3,'eCPM',18,1,1),
 (16,5,4,'eCPM',20,1,1),
 (16,5,5,'eCPM',20,1,1),
 (16,5,7,'eCPM',18,1,1),
 (16,5,8,'eCPM',18,1,1),
 (16,6,1,'eCPM',18,1,1),
 (16,6,2,'eCPM',18,1,1),
 (16,6,3,'eCPM',18,1,1),
 (16,6,4,'eCPM',20,1,1),
 (16,6,5,'eCPM',20,1,1),
 (16,6,7,'eCPM',18,1,1),
 (16,6,8,'eCPM',18,1,1),
 (16,7,1,'eCPM',18,1,1),
 (16,7,2,'eCPM',18,1,1),
 (16,7,3,'eCPM',18,1,1),
 (16,7,4,'eCPM',20,1,1),
 (16,7,5,'eCPM',20,1,1),
 (16,7,7,'eCPM',18,1,1),
 (16,7,8,'eCPM',18,1,1),
 (16,8,1,'eCPM',18,1,1),
 (16,8,2,'eCPM',18,1,1),
 (16,8,3,'eCPM',18,1,1),
 (16,8,4,'eCPM',20,1,1),
 (16,8,5,'eCPM',20,1,1),
 (16,8,7,'eCPM',18,1,1),
 (16,8,8,'eCPM',18,1,1),
 (17,4,1,'P/L',17,1,1),
 (17,4,4,'P/L',19,1,1),
 (17,4,5,'P/L',19,1,1),
 (17,4,6,'P/L',17,1,1),
 (17,4,7,'P/L',17,1,1),
 (17,4,8,'P/L',17,1,1),
 (17,4,9,'P/L',17,1,1),
 (17,4,10,'P/L',9,1,1),
 (17,5,1,'P/L',17,1,1),
 (17,5,2,'P/L',17,1,1),
 (17,5,3,'P/L',17,1,1),
 (17,5,4,'P/L',19,1,1),
 (17,5,5,'P/L',19,1,1),
 (17,5,6,'P/L',17,1,1),
 (17,5,7,'P/L',17,1,1),
 (17,5,8,'P/L',17,1,1),
 (17,5,9,'P/L',17,1,1),
 (17,5,10,'P/L',17,1,1),
 (17,6,1,'P/L',17,1,1),
 (17,6,2,'P/L',17,1,1),
 (17,6,3,'P/L',17,1,1),
 (17,6,4,'P/L',19,1,1),
 (17,6,5,'P/L',19,1,1),
 (17,6,6,'P/L',17,1,1),
 (17,6,7,'P/L',17,1,1),
 (17,6,8,'P/L',17,1,1),
 (17,6,9,'P/L',17,1,1),
 (17,6,10,'P/L',17,1,1),
 (17,7,1,'P/L',17,1,1),
 (17,7,2,'P/L',17,1,1),
 (17,7,3,'P/L',17,1,1),
 (17,7,4,'P/L',19,1,1),
 (17,7,5,'P/L',19,1,1),
 (17,7,6,'P/L',17,1,1),
 (17,7,7,'P/L',17,1,1),
 (17,7,8,'P/L',17,1,1),
 (17,7,9,'P/L',17,1,1),
 (17,7,10,'P/L',17,1,1),
 (17,8,1,'P/L',17,1,1),
 (17,8,2,'P/L',17,1,1),
 (17,8,3,'P/L',17,1,1),
 (17,8,4,'P/L',19,1,1),
 (17,8,5,'P/L',19,1,1),
 (17,8,6,'P/L',17,1,1),
 (17,8,7,'P/L',17,1,1),
 (17,8,8,'P/L',17,1,1),
 (17,8,9,'P/L',17,1,1),
 (17,8,10,'P/L',17,1,1),
 (18,4,1,'ROI',19,1,1),
 (18,4,4,'ROI',21,1,1),
 (18,4,5,'ROI',21,1,1),
 (18,4,6,'ROI',19,1,1),
 (18,4,7,'ROI',19,1,1),
 (18,4,8,'ROI',19,1,1),
 (18,4,9,'ROI',19,1,1),
 (18,4,10,'ROI',10,1,1),
 (18,5,1,'ROI',19,1,1),
 (18,5,2,'ROI',19,1,1),
 (18,5,3,'ROI',19,1,1),
 (18,5,4,'ROI',21,1,1),
 (18,5,5,'ROI',21,1,1),
 (18,5,6,'ROI',19,1,1),
 (18,5,7,'ROI',19,1,1),
 (18,5,8,'ROI',19,1,1),
 (18,5,9,'ROI',19,1,1),
 (18,5,10,'ROI',19,1,1),
 (18,6,1,'ROI',19,1,1),
 (18,6,2,'ROI',19,1,1),
 (18,6,3,'ROI',19,1,1),
 (18,6,4,'ROI',21,1,1),
 (18,6,5,'ROI',21,1,1),
 (18,6,6,'ROI',19,1,1),
 (18,6,7,'ROI',19,1,1),
 (18,6,8,'ROI',19,1,1),
 (18,6,9,'ROI',19,1,1),
 (18,6,10,'ROI',19,1,1),
 (18,7,1,'ROI',19,1,1),
 (18,7,2,'ROI',19,1,1),
 (18,7,3,'ROI',19,1,1),
 (18,7,4,'ROI',21,1,1),
 (18,7,5,'ROI',21,1,1),
 (18,7,6,'ROI',19,1,1),
 (18,7,7,'ROI',19,1,1),
 (18,7,8,'ROI',19,1,1),
 (18,7,9,'ROI',19,1,1),
 (18,7,10,'ROI',19,1,1),
 (18,8,1,'ROI',19,1,1),
 (18,8,2,'ROI',19,1,1),
 (18,8,3,'ROI',19,1,1),
 (18,8,4,'ROI',21,1,1),
 (18,8,5,'ROI',21,1,1),
 (18,8,6,'ROI',19,1,1),
 (18,8,7,'ROI',19,1,1),
 (18,8,8,'ROI',19,1,1),
 (18,8,9,'ROI',19,1,1),
 (18,8,10,'ROI',19,1,1),
 (19,4,2,'Engage%',6,1,1),
 (19,4,4,'Engage%',6,1,1),
 (19,4,5,'Engage%',6,1,1),
 (19,4,7,'Engage%',6,1,1),
 (19,4,8,'Engage%',6,1,1),
 (19,5,2,'Engage%',6,1,1),
 (19,5,4,'Engage%',6,1,1),
 (19,5,5,'Engage%',6,1,1),
 (19,5,7,'Engage%',6,1,1),
 (19,5,8,'Engage%',6,1,1),
 (19,6,2,'Engage%',6,1,1),
 (19,6,4,'Engage%',6,1,1),
 (19,6,5,'Engage%',6,1,1),
 (19,6,7,'Engage%',6,1,1),
 (19,6,8,'Engage%',6,1,1),
 (19,7,2,'Engage%',6,1,1),
 (19,7,4,'Engage%',6,1,1),
 (19,7,5,'Engage%',6,1,1),
 (19,7,7,'Engage%',6,1,1),
 (19,7,8,'Engage%',6,1,1),
 (19,8,2,'Engage%',6,1,1),
 (19,8,4,'Engage%',6,1,1),
 (19,8,5,'Engage%',6,1,1),
 (19,8,7,'Engage%',6,1,1),
 (19,8,8,'Engage%',6,1,1),
 (19,9,2,'Engage%',6,1,1),
 (19,9,5,'Engage%',7,1,1),
 (19,9,7,'Engage%',6,1,1),
 (19,9,8,'Engage%',6,1,1),
 (20,4,7,' ',1,1,1),
 (20,4,8,' ',1,1,1),
 (20,5,7,' ',1,1,1),
 (20,5,8,' ',1,1,1),
 (20,6,7,' ',1,1,1),
 (20,6,8,' ',1,1,1),
 (20,7,7,' ',1,1,1),
 (20,7,8,' ',1,1,1),
 (20,8,7,' ',1,1,1),
 (20,8,8,' ',1,1,1),
 (20,9,7,' ',1,1,1),
 (20,9,8,' ',1,1,1),
 (21,4,4,'Offer',14,0,0),
 (21,4,5,'Offer',14,0,0),
 (21,5,4,'Offer',14,0,0),
 (21,5,5,'Offer',14,0,0),
 (21,6,4,'Offer',14,0,0),
 (21,6,5,'Offer',14,0,0),
 (21,7,4,'Offer',14,1,1),
 (21,7,5,'Offer',14,0,0),
 (21,8,4,'Offer',14,0,0),
 (21,8,5,'Offer',14,0,0),
 (21,9,4,'Offer',14,0,0),
 (21,9,5,'Offer',15,0,0),
 (22,4,4,'Offer Url',15,0,0),
 (22,4,5,'Offer Url',15,0,0),
 (22,5,4,'Offer Url',15,0,0),
 (22,5,5,'Offer Url',15,0,0),
 (22,6,4,'Offer Url',15,0,0),
 (22,6,5,'Offer Url',15,0,0),
 (22,7,4,'Offer Url',15,0,0),
 (22,7,5,'Offer Url',15,0,0),
 (22,8,4,'Offer Url',15,0,0),
 (22,8,5,'Offer Url',15,0,0),
 (22,9,4,'Offer Url',15,0,0),
 (22,9,5,'Offer Url',16,0,0),
 (25,9,1,'EPS',18,1,1),
 (25,9,4,'EPS',18,1,1),
 (25,9,9,'EPS',18,1,1),
 (25,9,10,'EPS',18,1,1),
 (26,6,11,'Embed',6,1,1),
 (27,6,11,'Embed%',7,1,1),
 (28,6,11,'Popup',8,1,1),
 (29,6,11,'Popup%',9,1,1),
 (30,6,11,'Exit',10,1,1),
 (31,6,11,'Exit%',11,1,1),
 (32,4,5,'ID',1,1,1),
 (32,4,6,'ID',1,1,1),
 (32,5,5,'ID',1,1,1),
 (32,5,6,'ID',1,1,1),
 (32,6,5,'ID',1,1,1),
 (32,6,6,'ID',1,1,1),
 (32,6,11,'ID',1,1,1),
 (32,7,5,'ID',1,1,1),
 (32,7,6,'ID',1,1,1),
 (32,8,5,'ID',1,1,1),
 (32,8,6,'ID',1,1,1),
 (32,9,5,'ID',1,1,1),
 (32,9,6,'ID',1,1,1),
 (33,9,1,'Email',2,1,1),
 (33,9,4,'Email',2,1,1),
 (33,9,5,'Email',2,1,1),
 (33,9,6,'Email',2,1,1),
 (34,4,2,'Subscribers',9,1,1),
 (34,4,4,'Subscribers',9,1,1),
 (34,4,5,'Subscribers',9,1,1),
 (34,4,7,'Subscribers',9,1,1),
 (34,4,8,'Subscribers',9,1,1),
 (34,4,10,'Subscribers',12,1,1),
 (34,6,11,'Subscribers',12,1,1),
 (35,4,2,'SR',10,1,1),
 (35,4,4,'SR',10,1,1),
 (35,4,5,'SR',10,1,1),
 (35,4,7,'SR',10,1,1),
 (35,4,8,'SR',10,1,1),
 (35,4,10,'SR',13,1,1),
 (35,6,11,'SR',13,1,1),
 (36,4,2,'CPSUB',11,1,1),
 (36,4,4,'CPSUB',11,1,1),
 (36,4,5,'CPSUB',11,1,1),
 (36,4,7,'CPSUB',11,1,1),
 (36,4,8,'CPSUB',11,1,1),
 (36,4,10,'CPSUB',14,1,1);
/*!40000 ALTER TABLE `columnstypes` ENABLE KEYS */;


--
-- Definition of table `cpvsources`
--
CREATE TABLE `cpvsources` (
  `CpvSourceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Source` varchar(255) NOT NULL,
  `SourceID` varchar(255) NOT NULL,
  `KeywordToken` varchar(255) NOT NULL,
  `AppendToken` varchar(255) NOT NULL DEFAULT '',
  `Timezone` varchar(100) NOT NULL DEFAULT 'America/New_York',
  `DateAdded` datetime NOT NULL,
  PRIMARY KEY (`CpvSourceID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cpvsources`
--

/*!40000 ALTER TABLE `cpvsources` DISABLE KEYS */;
INSERT INTO `cpvsources` (`CpvSourceID`,`Source`,`SourceID`,`KeywordToken`,`AppendToken`,`Timezone`,`DateAdded`) VALUES 
 (1,'MediaTraffic','tm','target_passthrough','','America/New_York','2010-03-21 10:40:09'),
 (2,'Direct CPV - url','dtu','keyword','&keyword={{sm_vurl}}','America/New_York','2010-04-26 00:00:00'),
 (3,'Direct CPV - keyword','dt','keyword','&keyword={{keyword}}','America/New_York','2010-04-24 10:58:42'),
 (4,'Jema Media','mam','keyword','&keyword=[keyword]','America/Chicago','2010-04-24 10:58:53'),
 (5,'Ad On Network','nad','keyword','&keyword=SEARCHTEXT','America/Los_Angeles','2010-04-24 10:59:05'),
 (6,'Lead Impact','dlp','keyword','&keyword=%KEYWORD%','America/Los_Angeles','2010-04-24 10:59:46'),
 (7,'CPV Marketplace','cpl','keyword','&keyword=[keyword]','America/New_York','2010-04-24 11:00:07'),
 (8,'Trafficvance','tv','keyword','&keyword=%%$KEYWORD%%','America/Los_Angeles','2010-04-27 00:00:00'),
 (9,'Clicksor','cs','keyword','&keyword=[keyword]','America/New_York','2010-04-27 00:00:00');
/*!40000 ALTER TABLE `cpvsources` ENABLE KEYS */;


--
-- Definition of table `cpvtemplates`
--
CREATE TABLE `cpvtemplates` (
  `CpvTemplateID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CpvTemplate` varchar(200) NOT NULL,
  `RowsToSkip` int(10) unsigned NOT NULL,
  `KeywordColumn` varchar(200) NOT NULL,
  `ViewsColumn` varchar(200) NOT NULL,
  `CostColumn` varchar(200) NOT NULL,
  `CampaignIDColumn` varchar(200) NOT NULL DEFAULT 'CampaignID',
  `CampaignNameColumn` varchar(200) NOT NULL DEFAULT 'Campaign',
  `Active` tinyint(1) NOT NULL,
  `CpvSourceID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`CpvTemplateID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cpvtemplates`
--

/*!40000 ALTER TABLE `cpvtemplates` DISABLE KEYS */;
INSERT INTO `cpvtemplates` (`CpvTemplateID`,`CpvTemplate`,`RowsToSkip`,`KeywordColumn`,`ViewsColumn`,`CostColumn`,`CampaignIDColumn`,`CampaignNameColumn`,`Active`,`CpvSourceID`) VALUES 
 (1,'MediaTraffic - Target, Categories Report',2,'Targets|Categories','Views','Amounts','CampaignID','Campaign',1,1),
 (2,'Jema Media - Keyword Report',7,'Keyword','Impressions','Cost','CampaignID','Campaign',1,4),
 (3,'AdOnNetwork - Keyword Report - Standard Report',4,'Keyword ',' Views ',' Amt Spent ','CampaignID','Campaign',1,5),
 (4,'AdOnNetwork - Keyword Report - Daily Breakdown',4,'Keyword ',' Views ',' Amt Spent ','CampaignID','Campaign',1,5),
 (5,'Trafficvance - Daily Targets Export',0,'Target','Impressions','Cost','CampaignID','Campaign',1,8),
 (6,'Trafficvance - Monthly Targets Export',0,'Target','Impressions','Cost','CampaignID','Campaign',1,8),
 (7,'LeadImpact - Keyword Level',0,'Keyword','BillingImpressions','BillingRevenue','CampaignID','Campaign',1,6);
/*!40000 ALTER TABLE `cpvtemplates` ENABLE KEYS */;


--
-- Definition of table `destinations`
--
CREATE TABLE `destinations` (
  `DestinationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CampaignID` int(11) NOT NULL,
  `PathID` int(11) NOT NULL DEFAULT '0',
  `Offer` varchar(500) NOT NULL,
  `Url` varchar(500) NOT NULL,
  `Payout` double NOT NULL DEFAULT '0',
  `Share` int(11) NOT NULL DEFAULT '0',
  `CurrentShare` int(11) NOT NULL DEFAULT '0',
  `LandingPageID` int(11) NOT NULL DEFAULT '0',
  `TotalViews` int(11) NOT NULL DEFAULT '0',
  `AffiliateSourceID` int(10) unsigned NOT NULL DEFAULT '1',
  `Level` int(11) NOT NULL DEFAULT '1',
  `Sent` int(11) NOT NULL DEFAULT '0',
  `SharePath` int(11) NOT NULL DEFAULT '50',
  `CurrentSharePath` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`DestinationID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `destinations`
--

/*!40000 ALTER TABLE `destinations` DISABLE KEYS */;
/*!40000 ALTER TABLE `destinations` ENABLE KEYS */;


--
-- Definition of table `hiddencampaignalerts`
--
CREATE TABLE `hiddencampaignalerts` (
  `CampaignID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Views` bigint(20) NOT NULL,
  PRIMARY KEY (`CampaignID`,`Views`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hiddencampaignalerts`
--

/*!40000 ALTER TABLE `hiddencampaignalerts` DISABLE KEYS */;
/*!40000 ALTER TABLE `hiddencampaignalerts` ENABLE KEYS */;


--
-- Definition of table `hiddentargetalerts`
--
CREATE TABLE `hiddentargetalerts` (
  `CampaignID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `SubIdID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`CampaignID`,`SubIdID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hiddentargetalerts`
--

/*!40000 ALTER TABLE `hiddentargetalerts` DISABLE KEYS */;
/*!40000 ALTER TABLE `hiddentargetalerts` ENABLE KEYS */;


--
-- Definition of table `optimizations`
--
CREATE TABLE `optimizations` (
  `OptimizeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `OptimizeName` varchar(45) NOT NULL,
  `OptimizeValue` varchar(45) NOT NULL,
  PRIMARY KEY (`OptimizeID`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `optimizations`
--

/*!40000 ALTER TABLE `optimizations` DISABLE KEYS */;
INSERT INTO `optimizations` (`OptimizeID`,`OptimizeName`,`OptimizeValue`) VALUES 
 (1,'topt1ROI',''),
 (2,'topt1PPV',''),
 (3,'lopt2ROI',''),
 (4,'lopt2PPV',''),
 (5,'oopt3ROI',''),
 (6,'topt4Views',''),
 (7,'topt4Clicks',''),
 (8,'topt5Views',''),
 (9,'topt5Conversion',''),
 (10,'topt6Views',''),
 (11,'topt6ROI',''),
 (12,'topt6PPV',''),
 (13,'lopt7Views',''),
 (14,'lopt7Clicks',''),
 (15,'lopt8Views',''),
 (16,'lopt8Conversion',''),
 (17,'oopt9Views',''),
 (18,'oopt9Conversion',''),
 (19,'oopt10Visitors',''),
 (20,'oopt10Conversion','');
/*!40000 ALTER TABLE `optimizations` ENABLE KEYS */;


--
-- Definition of table `reportdetailscampaign`
--
CREATE TABLE `reportdetailscampaign` (
  `ReportDetailID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ReportID` int(10) unsigned NOT NULL,
  `CampaignID` int(10) unsigned NOT NULL,
  `Views` int(11) NOT NULL DEFAULT '0',
  `Clicks` int(10) unsigned NOT NULL DEFAULT '0',
  `CTR` double NOT NULL DEFAULT '0',
  `Cost` double NOT NULL DEFAULT '0',
  `Revenue` double NOT NULL DEFAULT '0',
  `EPV` double NOT NULL DEFAULT '0',
  `PPV` double NOT NULL DEFAULT '0',
  `Profit` double NOT NULL DEFAULT '0',
  `ROI` double NOT NULL DEFAULT '0',
  `Conversion` int(11) NOT NULL DEFAULT '0',
  `CR` double NOT NULL DEFAULT '0',
  `Sent` int(11) NOT NULL DEFAULT '0',
  `EPS` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`ReportDetailID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `reportdetailscampaign`
--

/*!40000 ALTER TABLE `reportdetailscampaign` DISABLE KEYS */;
/*!40000 ALTER TABLE `reportdetailscampaign` ENABLE KEYS */;

--
-- Definition of table `reportdetailsgroup`
--
CREATE TABLE `reportdetailsgroup` (
  `ReportDetailID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ReportID` int(10) unsigned NOT NULL,
  `SubIdID` int(10) unsigned NOT NULL,
  `Views` int(10) unsigned NOT NULL,
  `Cost` double NOT NULL,
  `CPV` double DEFAULT NULL,
  `Clicks` int(11) NOT NULL DEFAULT '0',
  `CTR` double NOT NULL DEFAULT '0',
  `CPC` double NOT NULL DEFAULT '0',
  `Conversion` int(11) NOT NULL DEFAULT '0',
  `CR` double NOT NULL DEFAULT '0',
  `Revenue` double NOT NULL DEFAULT '0',
  `EPV` double DEFAULT '0',
  `PPV` double DEFAULT '0',
  `eCPM` double NOT NULL,
  `Profit` double NOT NULL,
  `ROI` double NOT NULL DEFAULT '0',
  `Engages` int(11) NOT NULL DEFAULT '0',
  `EngageRate` double NOT NULL DEFAULT '0',
  `Sent` int(11) NOT NULL DEFAULT '0',
  `EPS` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`ReportDetailID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `reportdetailsgroup`
--

/*!40000 ALTER TABLE `reportdetailsgroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `reportdetailsgroup` ENABLE KEYS */;

--
-- Definition of table `reports`
--
CREATE TABLE `reports` (
  `ReportID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ReportName` varchar(100) NOT NULL,
  `CampaignID` int(10) unsigned NOT NULL,
  `DateAdded` datetime NOT NULL,
  PRIMARY KEY (`ReportID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `reports`
--

/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;


--
-- Definition of table `reporttypes`
--
CREATE TABLE `reporttypes` (
  `ReportTypeID` int(10) unsigned NOT NULL,
  `ReportTypeName` varchar(200) NOT NULL,
  PRIMARY KEY (`ReportTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `reporttypes`
--

/*!40000 ALTER TABLE `reporttypes` DISABLE KEYS */;
INSERT INTO `reporttypes` (`ReportTypeID`,`ReportTypeName`) VALUES 
 (1,'Reports Target'),
 (2,'Reports Landing'),
 (3,'Reports Offer'),
 (4,'Stats Target'),
 (5,'Stats Landing'),
 (6,'Stats Offer'),
 (7,'Trends Time'),
 (8,'Trends Day'),
 (9,'Reports Campaign'),
 (10,'Stats Campaign'),
 (11,'Stats Opt-In'),
 (12,'Stats Thank You');
/*!40000 ALTER TABLE `reporttypes` ENABLE KEYS */;


--
-- Definition of table `subids`
--
CREATE TABLE `subids` (
  `SubIdID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `SubId` varchar(45) NOT NULL,
  `Keyword` varchar(250) NOT NULL,
  `DateAdded` datetime NOT NULL,
  PRIMARY KEY (`SubIdID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `subids`
--

/*!40000 ALTER TABLE `subids` DISABLE KEYS */;
/*!40000 ALTER TABLE `subids` ENABLE KEYS */;


--
-- Definition of table `tempreferrers`
--
CREATE TABLE `tempreferrers` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Url` varchar(1500) NOT NULL,
  `ReferrerUrl` varchar(1500) NOT NULL,
  `JsReferrerUrl` varchar(1500) NOT NULL,
  `CampaignID` int(10) unsigned DEFAULT NULL,
  `DateAdded` datetime NOT NULL,
  `Type` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `tempreferrers`
--

/*!40000 ALTER TABLE `tempreferrers` DISABLE KEYS */;
/*!40000 ALTER TABLE `tempreferrers` ENABLE KEYS */;


--
-- Definition of table `tempurls`
--
CREATE TABLE `tempurls` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Url` varchar(1500) NOT NULL,
  `ReferrerUrl` varchar(1500) NOT NULL,
  `CampaignID` int(10) unsigned NOT NULL,
  `DateAdded` datetime NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `tempurls`
--

/*!40000 ALTER TABLE `tempurls` DISABLE KEYS */;
/*!40000 ALTER TABLE `tempurls` ENABLE KEYS */;


--
-- Definition of table `users`
--
CREATE TABLE `users` (
  `UserID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Username` varchar(45) NOT NULL DEFAULT '',
  `Password` varchar(45) NOT NULL DEFAULT '',
  `DateAdded` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `LastLogin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Timezone` varchar(100) NOT NULL DEFAULT 'America/New_York',
  `StatsInterval` int(10) unsigned DEFAULT '8',
  `StatsCustomFrom` varchar(45) DEFAULT '',
  `StatsCustomTo` varchar(45) DEFAULT '',
  `SessionTimeout` int(11) NOT NULL DEFAULT '30',
  `RedirectType` tinyint(3) unsigned NOT NULL DEFAULT '2',
  PRIMARY KEY (`UserID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `users`
--

/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`UserID`,`Username`,`Password`,`DateAdded`,`LastLogin`,`Timezone`,`StatsInterval`,`StatsCustomFrom`,`StatsCustomTo`,`SessionTimeout`,`RedirectType`) VALUES 
 (1,'admin','21232f297a57a5a743894a0e4a801fc3','2008-01-13 00:00:00','2010-07-15 17:45:29','America/New_York',8,'','',30,2);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;







--
-- Definition of table `columns`
--
TRUNCATE TABLE `columns`;

--
-- Dumping data for table `columns`
--

/*!40000 ALTER TABLE `columns` DISABLE KEYS */;
INSERT INTO `columns` (`ColumnID`,`ColumnName`,`ColumnSort`,`ClassName`,`ColumnColor`,`DecimalPlaces`,`IsPercent`,`IsDollar`,`IsSortable`,`IsFixed`) VALUES 
 (1,'CampaignID','CampaignID','','034CB5',-1,0,0,0,0),
 (2,'Offer','Offer','left','034CB5',-1,0,0,1,0),
 (3,'Url','Url','left','034CB5',-1,0,0,1,0),
 (4,'Keyword','Keyword','left','034CB5',-1,0,0,1,0),
 (5,'Views','Views','','034CB5',0,0,0,1,0),
 (6,'Cost','Cost','','034CB5',2,0,1,1,0),
 (7,'CPV','CPV','','034CB5',3,0,1,1,0),
 (8,'Clicks','Clicks','','034CB5',0,0,0,1,0),
 (9,'CTR','CTR','','034CB5',2,1,0,1,0),
 (10,'CPC','CPC','','034CB5',2,0,1,1,0),
 (11,'Conversion','Conversion','','034CB5',0,0,0,1,0),
 (12,'CR','CR','','034CB5',2,1,0,1,0),
 (13,'Revenue','Revenue','','034CB5',2,0,1,1,0),
 (14,'EPV','EPV','','034CB5',3,0,1,1,0),
 (15,'PPV','PPV','','034CB5',3,0,1,1,0),
 (16,'eCPM','eCPM','','034CB5',2,0,1,1,0),
 (17,'Profit','Profit','','034CB5',2,0,1,1,0),
 (18,'ROI','ROI','','034CB5',2,1,0,1,0),
 (19,'EngageRate','EngageRate','','034CB5',2,1,0,1,0),
 (20,'TheIntervalName','TheIntervalName','left bold','034CB5',-1,0,0,0,0),
 (21,'Offer2','Offer2','left','034CB5',-1,0,0,1,0),
 (22,'Url2','Url2','left','034CB5',-1,0,0,1,0),
 (23,'CostRevenueProfit','CostRevenueProfit','','034CB5',-1,0,1,0,0),
 (24,'Sent','Sent','','034CB5',-1,0,0,1,0),
 (25,'EPS','EPS','','034CB5',2,0,1,1,0),
 (26,'Embed','Embed','','034CB5',0,0,0,0,0),
 (27,'EmbedPercent','EmbedPercent','','034CB5',2,1,0,0,0),
 (28,'Popup','Popup','','034CB5',0,0,0,0,0),
 (29,'PopupPercent','PopupPercent','','034CB5',2,1,0,0,0),
 (30,'Exit','Exit','','034CB5',0,0,0,0,0),
 (31,'ExitPercent','ExitPercent','','034CB5',2,1,0,0,0),
 (32,'DestinationID','DestinationID','','034CB5',-1,0,0,1,0),
 (33,'Email','Email','left','034CB5',-1,0,0,1,0),
 (34,'Subscribers','Subscribers','','034CB5',0,0,0,1,0),
 (35,'SR','SR','','034CB5',2,1,0,1,0),
 (36,'CPSUB','CPSUB','','034CB5',2,0,1,1,0),
 (37,'Extra1','Extra1','left','034CB5',-1,0,0,1,1),
 (38,'Extra2','Extra2','left','034CB5',-1,0,0,1,1),
 (39,'Extra3','Extra3','left','034CB5',-1,0,0,1,1),
 (40,'Extra4','Extra4','left','034CB5',-1,0,0,1,1),
 (41,'Extra5','Extra5','left','034CB5',-1,0,0,1,1),
 (42,'Extra6','Extra6','left','034CB5',-1,0,0,1,1),
 (43,'Extra7','Extra7','left','034CB5',-1,0,0,1,1),
 (44,'Extra8','Extra8','left','034CB5',-1,0,0,1,1),
 (45,'Extra9','Extra9','left','034CB5',-1,0,0,1,1),
 (46,'Extra10','Extra10','left','034CB5',-1,0,0,1,1),
 (47,'CPA','CPA','','034CB5',2,0,1,1,0);
/*!40000 ALTER TABLE `columns` ENABLE KEYS */;


--
-- Definition of table `columnscharts`
--
DELETE FROM `columnscharts`;

--
-- Dumping data for table `columnscharts`
--

/*!40000 ALTER TABLE `columnscharts` DISABLE KEYS */;
INSERT INTO `columnscharts` (`ColumnID`,`CampaignTypeID`,`ReportTypeID`,`ColumnCaption`,`ColumnIndex`,`IsVisible`) VALUES 
 (5,4,5,'Views',1,1),
 (5,4,7,'Views',1,1),
 (5,4,8,'Views',1,1),
 (5,4,13,'Views',1,1),
 (5,5,5,'Views',1,1),
 (5,5,7,'Views',1,1),
 (5,5,8,'Views',1,1),
 (5,5,13,'Views',1,1),
 (5,6,5,'Views',1,1),
 (5,6,7,'Views',1,1),
 (5,6,8,'Views',1,1),
 (5,6,11,'Visitors',5,1),
 (5,6,13,'Views',1,1),
 (5,7,5,'Views',1,1),
 (5,7,7,'Views',1,1),
 (5,7,8,'Views',1,1),
 (5,7,13,'Views',1,1),
 (5,8,5,'Views',1,1),
 (5,8,7,'Views',1,1),
 (5,8,8,'Views',1,1),
 (5,8,13,'Views',1,1),
 (5,9,5,'Views',1,1),
 (5,9,7,'Views',1,1),
 (5,9,8,'Views',1,1),
 (5,9,13,'Views',1,1),
 (8,4,5,'Clicks',3,0),
 (8,4,6,'Visitors',2,1),
 (8,5,5,'Clicks',3,0),
 (8,5,6,'Visitors',2,1),
 (8,5,7,'Clicks',2,0),
 (8,5,8,'Clicks',2,0),
 (8,5,13,'Clicks',2,0),
 (8,6,5,'Clicks',3,0),
 (8,6,6,'Visitors',2,1),
 (8,6,7,'Clicks',2,0),
 (8,6,8,'Clicks',2,0),
 (8,6,13,'Clicks',2,0),
 (8,7,5,'Clicks',3,0),
 (8,7,6,'Visitors',2,1),
 (8,7,7,'Clicks',2,0),
 (8,7,8,'Clicks',2,0),
 (8,7,13,'Clicks',2,0),
 (8,8,5,'Clicks',3,0),
 (8,8,6,'Visitors',2,1),
 (8,8,7,'Clicks',2,0),
 (8,8,8,'Clicks',2,0),
 (8,8,13,'Clicks',2,0),
 (8,9,4,'Clicks',1,1),
 (8,9,5,'Clicks',3,0),
 (8,9,6,'Visitors',1,1),
 (8,9,7,'Clicks',2,0),
 (8,9,8,'Clicks',2,0),
 (8,9,13,'Clicks',2,0),
 (9,4,5,'CTR%',4,0),
 (9,5,5,'CTR%',4,0),
 (9,5,7,'CTR',3,0),
 (9,5,8,'CTR',3,0),
 (9,5,13,'CTR',3,0),
 (9,6,5,'CTR%',4,0),
 (9,6,7,'CTR',3,0),
 (9,6,8,'CTR',3,0),
 (9,6,13,'CTR',3,0),
 (9,7,5,'CTR%',4,0),
 (9,7,7,'CTR',3,0),
 (9,7,8,'CTR',3,0),
 (9,7,13,'CTR',3,0),
 (9,8,5,'CTR%',4,0),
 (9,8,7,'CTR',3,0),
 (9,8,8,'CTR',3,0),
 (9,8,13,'CTR',3,0),
 (9,9,4,'CTR%',2,0),
 (9,9,5,'CTR%',4,0),
 (9,9,7,'CTR',3,0),
 (9,9,8,'CTR',3,0),
 (9,9,13,'CTR',3,0),
 (10,4,5,'CPC',5,0),
 (10,4,6,'CPC',3,0),
 (10,5,5,'CPC',5,0),
 (10,5,6,'CPC',3,0),
 (10,6,5,'CPC',5,0),
 (10,6,6,'CPC',3,0),
 (10,7,5,'CPC',5,0),
 (10,7,6,'CPC',3,0),
 (10,8,5,'CPC',5,0),
 (10,8,6,'CPC',3,0),
 (11,4,5,'Conversions',9,0),
 (11,4,6,'Conversions',4,0),
 (11,4,7,'Conversions',3,0),
 (11,4,8,'Conversions',3,0),
 (11,4,13,'Conversions',3,0),
 (11,5,5,'Conversions',6,0),
 (11,5,6,'Conversions',4,0),
 (11,5,7,'Conversions',4,0),
 (11,5,8,'Conversions',4,0),
 (11,5,13,'Conversions',4,0),
 (11,6,5,'Conversions',6,0),
 (11,6,6,'Conversions',4,0),
 (11,6,7,'Conversions',4,0),
 (11,6,8,'Conversions',4,0),
 (11,6,13,'Conversions',4,0),
 (11,7,5,'Conversions',6,0),
 (11,7,6,'Conversions',4,0),
 (11,7,7,'Conversions',4,0),
 (11,7,8,'Conversions',4,0),
 (11,7,13,'Conversions',4,0),
 (11,8,5,'Conversions',6,0),
 (11,8,6,'Conversions',4,0),
 (11,8,7,'Conversions',4,0),
 (11,8,8,'Conversions',4,0),
 (11,8,13,'Conversions',4,0),
 (11,9,4,'Conversions',3,0),
 (11,9,6,'Conversions',2,0),
 (11,9,7,'Conversions',4,0),
 (11,9,8,'Conversions',4,0),
 (11,9,13,'Conversions',4,0),
 (12,4,5,'CR%',10,0),
 (12,4,6,'CR%',6,0),
 (12,5,5,'CR%',7,0),
 (12,5,6,'CR%',6,0),
 (12,5,7,'CR',5,0),
 (12,5,8,'CR',5,0),
 (12,5,13,'CR',5,0),
 (12,6,5,'CR%',7,0),
 (12,6,6,'CR%',6,0),
 (12,6,7,'CR',5,0),
 (12,6,8,'CR',5,0),
 (12,6,13,'CR',5,0),
 (12,7,5,'CR%',7,0),
 (12,7,6,'CR%',6,0),
 (12,7,7,'CR',5,0),
 (12,7,8,'CR',5,0),
 (12,7,13,'CR',5,0),
 (12,8,5,'CR%',7,0),
 (12,8,6,'CR%',6,0),
 (12,8,7,'CR',5,0),
 (12,8,8,'CR',5,0),
 (12,8,13,'CR',5,0),
 (12,9,4,'CR%',4,0),
 (12,9,6,'CR%',3,0),
 (12,9,7,'CR',5,0),
 (12,9,8,'CR',5,0),
 (12,9,13,'CR',5,0),
 (13,9,4,'Revenue',6,0),
 (13,9,5,'Revenue',5,0),
 (13,9,6,'Revenue',5,0),
 (13,9,7,'Revenue',8,0),
 (13,9,8,'Revenue',8,0),
 (13,9,13,'Revenue',8,0),
 (14,4,5,'EPV',12,0),
 (14,5,5,'EPV',9,0),
 (14,5,6,'EPV',8,0),
 (14,5,7,'EPV',6,0),
 (14,5,8,'EPV',6,0),
 (14,5,13,'EPV',6,0),
 (14,6,5,'EPV',9,0),
 (14,6,7,'EPV',6,0),
 (14,6,8,'EPV',6,0),
 (14,6,13,'EPV',6,0),
 (14,7,5,'EPV',9,0),
 (14,7,6,'EPV',8,0),
 (14,7,7,'EPV',6,0),
 (14,7,8,'EPV',6,0),
 (14,7,13,'EPV',6,0),
 (14,8,5,'EPV',9,0),
 (14,8,6,'EPV',8,0),
 (14,8,7,'EPV',6,0),
 (14,8,8,'EPV',6,0),
 (14,8,13,'EPV',6,0),
 (14,9,7,'EPV',6,0),
 (14,9,8,'EPV',6,0),
 (14,9,13,'EPV',6,0),
 (15,4,5,'PPV',13,0),
 (15,5,5,'PPV',10,0),
 (15,5,6,'PPV',9,0),
 (15,5,7,'PPV',7,0),
 (15,5,8,'PPV',7,0),
 (15,5,13,'PPV',7,0),
 (15,6,5,'PPV',10,0),
 (15,6,7,'PPV',7,0),
 (15,6,8,'PPV',7,0),
 (15,6,13,'PPV',7,0),
 (15,7,5,'PPV',10,0),
 (15,7,6,'PPV',9,0),
 (15,7,7,'PPV',7,0),
 (15,7,8,'PPV',7,0),
 (15,7,13,'PPV',7,0),
 (15,8,5,'PPV',10,0),
 (15,8,6,'PPV',9,0),
 (15,8,7,'PPV',7,0),
 (15,8,8,'PPV',7,0),
 (15,8,13,'PPV',7,0),
 (15,9,7,'PPV',7,0),
 (15,9,8,'PPV',7,0),
 (15,9,13,'PPV',7,0),
 (16,5,6,'eCPM',5,0),
 (16,7,6,'eCPM',5,0),
 (16,8,6,'eCPM',5,0),
 (17,4,7,'P/L',6,0),
 (17,4,8,'P/L',6,0),
 (17,4,13,'P/L',6,0),
 (17,5,7,'P/L',8,0),
 (17,5,8,'P/L',8,0),
 (17,5,13,'P/L',8,0),
 (17,6,7,'P/L',8,0),
 (17,6,8,'P/L',8,0),
 (17,6,13,'P/L',8,0),
 (17,7,7,'P/L',8,0),
 (17,7,8,'P/L',8,0),
 (17,7,13,'P/L',8,0),
 (17,8,7,'P/L',8,0),
 (17,8,8,'P/L',8,0),
 (17,8,13,'P/L',8,0),
 (18,4,5,'ROI%',14,0),
 (18,4,6,'ROI%',10,0),
 (18,5,5,'ROI%',11,0),
 (18,5,6,'ROI%',10,0),
 (18,6,5,'ROI%',11,0),
 (18,6,6,'ROI%',10,0),
 (18,7,5,'ROI%',11,0),
 (18,7,6,'ROI%',10,0),
 (18,8,5,'ROI%',11,0),
 (18,8,6,'ROI%',10,0),
 (19,4,5,'Engage%',2,0),
 (19,5,5,'Engage%',2,0),
 (19,6,5,'Engage%',2,0),
 (19,7,5,'Engage%',2,0),
 (19,8,5,'Engage%',2,0),
 (19,9,5,'Engage%',2,0),
 (23,4,5,'Revenue-Cost-P/L',15,0),
 (23,4,6,'Revenue-Cost-P/L',12,0),
 (23,5,5,'Revenue-Cost-P/L',12,0),
 (23,5,6,'Revenue-Cost-P/L',12,0),
 (23,6,5,'Revenue-Cost-P/L',12,0),
 (23,6,6,'Revenue-Cost-P/L',12,0),
 (23,7,5,'Revenue-Cost-P/L',12,0),
 (23,7,6,'Revenue-Cost-P/L',12,0),
 (23,8,5,'Revenue-Cost-P/L',12,0),
 (23,8,6,'Revenue-Cost-P/L',12,0),
 (26,6,11,'Embed',6,0),
 (27,6,11,'Embed%',7,0),
 (28,6,11,'Popup',8,0),
 (29,6,11,'Popup%',9,0),
 (30,6,11,'Exit',10,0),
 (31,6,11,'Exit%',11,0),
 (34,4,5,'Subscribers',6,0),
 (34,4,7,'Subscribers',2,0),
 (34,4,8,'Subscribers',2,0),
 (34,4,13,'Subscribers',2,0),
 (34,6,11,'Subscribers',12,0),
 (35,4,5,'SR%',7,0),
 (35,4,7,'SR%',4,0),
 (35,4,8,'SR%',4,0),
 (35,4,13,'SR%',4,0),
 (35,6,11,'SR',13,0),
 (36,4,5,'CPSUB',8,0),
 (36,4,7,'CPSUB',5,0),
 (36,4,8,'CPSUB',5,0),
 (36,4,13,'CPSUB',5,0),
 (47,4,5,'CPA',11,0),
 (47,4,6,'CPA',7,0),
 (47,5,5,'CPA',8,0),
 (47,5,6,'CPA',7,0),
 (47,6,5,'CPA',8,0),
 (47,6,6,'CPA',7,0),
 (47,7,5,'CPA',8,0),
 (47,7,6,'CPA',7,0),
 (47,8,5,'CPA',8,0),
 (47,8,6,'CPA',7,0),
 (47,9,4,'CPA',5,0),
 (47,9,6,'CPA',4,0);
/*!40000 ALTER TABLE `columnscharts` ENABLE KEYS */;

--
-- Definition of table `columnstypes`
--
DELETE FROM `columnstypes`;

--
-- Dumping data for table `columnstypes`
--

/*!40000 ALTER TABLE `columnstypes` DISABLE KEYS */;
INSERT INTO `columnstypes` (`ColumnID`,`CampaignTypeID`,`ReportTypeID`,`ColumnCaption`,`ColumnIndex`,`IsVisible`,`DefaultState`) VALUES 
 (1,4,1,'ID',1,1,1),
 (1,4,2,'ID',1,1,1),
 (1,4,4,'ID',1,1,1),
 (1,4,9,'ID',1,1,1),
 (1,4,10,'ID',1,1,1),
 (1,4,12,'ID',1,1,1),
 (1,5,1,'ID',1,1,1),
 (1,5,2,'ID',1,1,1),
 (1,5,3,'ID',1,1,1),
 (1,5,4,'ID',1,1,1),
 (1,5,9,'ID',1,1,1),
 (1,5,10,'ID',1,1,1),
 (1,6,1,'ID',1,1,1),
 (1,6,2,'ID',1,1,1),
 (1,6,3,'ID',1,1,1),
 (1,6,4,'ID',1,1,1),
 (1,6,9,'ID',1,1,1),
 (1,6,10,'ID',1,1,1),
 (1,6,12,'ID',1,1,1),
 (1,7,1,'ID',1,1,1),
 (1,7,2,'ID',1,1,1),
 (1,7,3,'ID',1,1,1),
 (1,7,4,'ID',1,1,1),
 (1,7,9,'ID',1,1,1),
 (1,7,10,'ID',1,1,1),
 (1,8,1,'ID',1,1,1),
 (1,8,2,'ID',1,1,1),
 (1,8,3,'ID',1,1,1),
 (1,8,4,'ID',1,1,1),
 (1,8,9,'ID',1,1,1),
 (1,8,10,'ID',1,1,1),
 (1,9,1,'ID',1,1,1),
 (1,9,2,'ID',1,1,1),
 (1,9,3,'ID',1,1,1),
 (1,9,4,'ID',1,1,1),
 (1,9,9,'ID',1,1,1),
 (1,9,10,'ID',1,1,1),
 (2,4,2,'Page',2,1,1),
 (2,4,4,'Page',2,0,1),
 (2,4,5,'Page',2,1,1),
 (2,4,6,'Offer',2,1,1),
 (2,4,9,'Name',2,1,1),
 (2,4,10,'Name',2,1,1),
 (2,4,12,'Name',2,1,1),
 (2,5,2,'Page',2,1,1),
 (2,5,3,'Offer',2,1,1),
 (2,5,4,'Page',2,0,1),
 (2,5,5,'Page',2,1,1),
 (2,5,6,'Offer',2,1,1),
 (2,5,9,'Name',2,1,1),
 (2,5,10,'Name',2,1,1),
 (2,6,2,'Page',2,1,1),
 (2,6,3,'Offer',2,1,1),
 (2,6,4,'Page',2,0,1),
 (2,6,5,'Page',2,1,1),
 (2,6,6,'Offer',2,1,1),
 (2,6,9,'Name',2,1,1),
 (2,6,10,'Name',2,1,1),
 (2,6,11,'Page',2,1,1),
 (2,6,12,'Name',2,1,1),
 (2,7,2,'Page',2,1,1),
 (2,7,3,'Offer',2,1,1),
 (2,7,4,'Page',2,0,1),
 (2,7,5,'Page',2,1,1),
 (2,7,6,'Offer',2,1,1),
 (2,7,9,'Name',2,1,1),
 (2,7,10,'Name',2,1,1),
 (2,8,2,'Page',2,1,1),
 (2,8,3,'Offer',2,1,1),
 (2,8,4,'Page',2,0,1),
 (2,8,5,'Page',2,1,1),
 (2,8,6,'Offer',2,1,1),
 (2,8,9,'Name',2,1,1),
 (2,8,10,'Name',2,1,1),
 (2,9,2,'Page',2,1,1),
 (2,9,3,'Offer',2,1,1),
 (2,9,5,'Page',3,1,1),
 (2,9,6,'Offer',3,1,1),
 (2,9,9,'Name',1,1,1),
 (2,9,10,'Name',2,1,1),
 (3,4,2,'URL',3,0,0),
 (3,4,4,'URL',3,0,0),
 (3,4,5,'URL',3,0,0),
 (3,4,6,'URL',3,0,0),
 (3,5,2,'URL',3,0,0),
 (3,5,3,'URL',3,0,0),
 (3,5,4,'URL',3,0,0),
 (3,5,5,'URL',3,0,0),
 (3,5,6,'URL',3,0,0),
 (3,6,2,'URL',3,0,0),
 (3,6,3,'URL',3,0,0),
 (3,6,4,'URL',3,0,0),
 (3,6,5,'URL',3,0,0),
 (3,6,6,'URL',3,0,0),
 (3,6,11,'URL',3,0,0),
 (3,7,2,'URL',3,0,0),
 (3,7,3,'URL',3,0,0),
 (3,7,4,'URL',3,0,0),
 (3,7,5,'URL',3,0,0),
 (3,7,6,'URL',3,0,0),
 (3,8,2,'URL',3,0,0),
 (3,8,3,'URL',3,0,0),
 (3,8,4,'URL',3,0,0),
 (3,8,5,'URL',3,0,0),
 (3,8,6,'URL',3,0,0),
 (3,9,2,'URL',3,0,0),
 (3,9,3,'URL',3,0,0),
 (3,9,5,'URL',4,0,0),
 (3,9,6,'URL',4,0,0),
 (4,4,1,'Target',4,1,1),
 (4,4,4,'Target',4,1,1),
 (4,5,1,'Target',4,1,1),
 (4,5,4,'Target',4,1,1),
 (4,6,1,'Target',4,1,1),
 (4,6,4,'Target',4,1,1),
 (4,7,1,'Target',4,1,1),
 (4,7,4,'Target',4,1,1),
 (4,8,1,'Target',4,1,1),
 (4,8,4,'Target',4,1,1),
 (5,4,1,'Views',5,1,1),
 (5,4,2,'Views',5,1,1),
 (5,4,4,'Views',15,1,1),
 (5,4,5,'Views',5,1,1),
 (5,4,7,'Views',5,1,1),
 (5,4,8,'Views',5,1,1),
 (5,4,9,'Views',5,1,1),
 (5,4,10,'Views',5,1,1),
 (5,4,12,'Visitors',5,1,1),
 (5,4,13,'Views',5,1,1),
 (5,5,1,'Views',5,1,1),
 (5,5,2,'Views',5,1,1),
 (5,5,4,'Views',15,1,1),
 (5,5,5,'Views',5,1,1),
 (5,5,7,'Views',5,1,1),
 (5,5,8,'Views',5,1,1),
 (5,5,9,'Views',5,1,1),
 (5,5,10,'Views',5,1,1),
 (5,5,13,'Views',5,1,1),
 (5,6,1,'Views',5,1,1),
 (5,6,2,'Views',5,1,1),
 (5,6,4,'Views',15,1,1),
 (5,6,5,'Views',5,1,1),
 (5,6,7,'Views',5,1,1),
 (5,6,8,'Views',5,1,1),
 (5,6,9,'Views',5,1,1),
 (5,6,10,'Views',5,1,1),
 (5,6,11,'Visitors',5,1,1),
 (5,6,12,'Visitors',5,1,1),
 (5,6,13,'Views',5,1,1),
 (5,7,1,'Views',5,1,1),
 (5,7,2,'Views',5,1,1),
 (5,7,4,'Views',15,1,1),
 (5,7,5,'Views',5,1,1),
 (5,7,7,'Views',5,1,1),
 (5,7,8,'Views',5,1,1),
 (5,7,9,'Views',5,1,1),
 (5,7,10,'Views',5,1,1),
 (5,7,13,'Views',5,1,1),
 (5,8,1,'Views',5,1,1),
 (5,8,2,'Views',5,1,1),
 (5,8,4,'Views',15,1,1),
 (5,8,5,'Views',5,1,1),
 (5,8,7,'Views',5,1,1),
 (5,8,8,'Views',5,1,1),
 (5,8,9,'Views',5,1,1),
 (5,8,10,'Views',5,1,1),
 (5,8,13,'Views',5,1,1),
 (5,9,1,'# Sent',5,1,1),
 (5,9,2,'Views',5,1,1),
 (5,9,4,'# Sent',5,1,1),
 (5,9,5,'Views',6,1,1),
 (5,9,7,'Views',5,1,1),
 (5,9,8,'Views',5,1,1),
 (5,9,9,'# Sent',4,1,1),
 (5,9,10,'# Sent',4,1,1),
 (5,9,13,'Views',5,1,1),
 (6,4,1,'Cost',7,1,1),
 (6,4,2,'Cost',7,1,1),
 (6,4,4,'Cost',17,1,1),
 (6,4,5,'Cost',7,1,1),
 (6,4,6,'Cost',9,1,1),
 (6,4,7,'Cost',7,1,1),
 (6,4,8,'Cost',7,1,1),
 (6,4,9,'Cost',7,1,1),
 (6,4,10,'Cost',7,1,1),
 (6,4,12,'Cost',7,1,1),
 (6,4,13,'Cost',7,1,1),
 (6,5,1,'Cost',7,1,1),
 (6,5,2,'Cost',7,1,1),
 (6,5,3,'Cost',7,1,1),
 (6,5,4,'Cost',17,1,1),
 (6,5,5,'Cost',7,1,1),
 (6,5,6,'Cost',9,1,1),
 (6,5,7,'Cost',7,1,1),
 (6,5,8,'Cost',7,1,1),
 (6,5,9,'Cost',7,1,1),
 (6,5,10,'Cost',7,1,1),
 (6,5,13,'Cost',7,1,1),
 (6,6,1,'Cost',7,1,1),
 (6,6,2,'Cost',7,1,1),
 (6,6,3,'Cost',7,1,1),
 (6,6,4,'Cost',17,1,1),
 (6,6,5,'Cost',7,1,1),
 (6,6,6,'Cost',9,1,1),
 (6,6,7,'Cost',7,1,1),
 (6,6,8,'Cost',7,1,1),
 (6,6,9,'Cost',7,1,1),
 (6,6,10,'Cost',7,1,1),
 (6,6,12,'Cost',7,1,1),
 (6,6,13,'Cost',7,1,1),
 (6,7,1,'Cost',7,1,1),
 (6,7,2,'Cost',7,1,1),
 (6,7,3,'Cost',9,1,1),
 (6,7,4,'Cost',17,1,1),
 (6,7,5,'Cost',7,1,1),
 (6,7,6,'Cost',9,1,1),
 (6,7,7,'Cost',7,1,1),
 (6,7,8,'Cost',7,1,1),
 (6,7,9,'Cost',7,1,1),
 (6,7,10,'Cost',7,1,1),
 (6,7,13,'Cost',7,1,1),
 (6,8,1,'Cost',7,1,1),
 (6,8,2,'Cost',7,1,1),
 (6,8,3,'Cost',9,1,1),
 (6,8,4,'Cost',17,1,1),
 (6,8,5,'Cost',7,1,1),
 (6,8,6,'Cost',9,1,1),
 (6,8,7,'Cost',7,1,1),
 (6,8,8,'Cost',7,1,1),
 (6,8,9,'Cost',7,1,1),
 (6,8,10,'Cost',7,1,1),
 (6,8,13,'Cost',7,1,1),
 (7,4,1,'CPV',8,1,1),
 (7,4,2,'CPV',8,1,1),
 (7,4,4,'CPV',18,1,1),
 (7,4,5,'CPV',8,1,1),
 (7,4,7,'CPV',8,1,1),
 (7,4,8,'CPV',8,1,1),
 (7,4,13,'CPV',8,1,1),
 (7,5,1,'CPV',8,1,1),
 (7,5,2,'CPV',8,1,1),
 (7,5,4,'CPV',18,1,1),
 (7,5,5,'CPV',8,1,1),
 (7,5,7,'CPV',8,1,1),
 (7,5,8,'CPV',8,1,1),
 (7,5,13,'CPV',8,1,1),
 (7,6,1,'CPV',8,1,1),
 (7,6,2,'CPV',8,1,1),
 (7,6,4,'CPV',18,1,1),
 (7,6,5,'CPV',8,1,1),
 (7,6,7,'CPV',8,1,1),
 (7,6,8,'CPV',8,1,1),
 (7,6,13,'CPV',8,1,1),
 (7,7,1,'CPV',8,1,1),
 (7,7,2,'CPV',8,1,1),
 (7,7,4,'CPV',18,1,1),
 (7,7,5,'CPV',8,1,1),
 (7,7,7,'CPV',8,1,1),
 (7,7,8,'CPV',8,1,1),
 (7,7,13,'CPV',8,1,1),
 (7,8,1,'CPV',8,1,1),
 (7,8,2,'CPV',8,1,1),
 (7,8,4,'CPV',18,1,1),
 (7,8,5,'CPV',8,1,1),
 (7,8,7,'CPV',8,1,1),
 (7,8,8,'CPV',8,1,1),
 (7,8,13,'CPV',8,1,1),
 (8,4,1,'Clicks',9,1,1),
 (8,4,5,'Clicks',9,1,1),
 (8,4,6,'Visitors',7,1,1),
 (8,4,12,'Clicks',8,1,1),
 (8,5,1,'Clicks',9,1,1),
 (8,5,2,'Clicks',9,1,1),
 (8,5,3,'Visitors',7,1,1),
 (8,5,4,'Clicks',19,1,1),
 (8,5,5,'Clicks',9,1,1),
 (8,5,6,'Visitors',7,1,1),
 (8,5,7,'Clicks',9,1,1),
 (8,5,8,'Clicks',9,1,1),
 (8,5,13,'Clicks',9,1,1),
 (8,6,1,'Clicks',9,1,1),
 (8,6,2,'Clicks',9,1,1),
 (8,6,3,'Visitors',7,1,1),
 (8,6,4,'Clicks',19,1,1),
 (8,6,5,'Clicks',9,1,1),
 (8,6,6,'Visitors',7,1,1),
 (8,6,7,'Clicks',9,1,1),
 (8,6,8,'Clicks',9,1,1),
 (8,6,12,'Clicks',8,1,1),
 (8,6,13,'Clicks',9,1,1),
 (8,7,1,'Clicks',9,1,1),
 (8,7,2,'Clicks',9,1,1),
 (8,7,3,'Visitors',7,1,1),
 (8,7,4,'Clicks',19,1,1),
 (8,7,5,'Clicks',9,1,1),
 (8,7,6,'Visitors',7,1,1),
 (8,7,7,'Clicks',9,1,1),
 (8,7,8,'Clicks',9,1,1),
 (8,7,13,'Clicks',9,1,1),
 (8,8,1,'Clicks',9,1,1),
 (8,8,2,'Clicks',9,1,1),
 (8,8,3,'Visitors',7,1,1),
 (8,8,4,'Clicks',19,1,1),
 (8,8,5,'Clicks',9,1,1),
 (8,8,6,'Visitors',7,1,1),
 (8,8,7,'Clicks',9,1,1),
 (8,8,8,'Clicks',9,1,1),
 (8,8,13,'Clicks',9,1,1),
 (8,9,1,'Clicks',9,1,1),
 (8,9,2,'Clicks',9,1,1),
 (8,9,3,'Visitors',7,1,1),
 (8,9,4,'Clicks',9,1,1),
 (8,9,5,'Clicks',10,1,1),
 (8,9,6,'Visitors',8,1,1),
 (8,9,7,'Clicks',9,1,1),
 (8,9,8,'Clicks',9,1,1),
 (8,9,9,'Clicks',9,1,1),
 (8,9,10,'Clicks',9,1,1),
 (8,9,13,'Clicks',9,1,1),
 (9,4,1,'CTR',10,1,1),
 (9,4,5,'CTR',10,1,1),
 (9,4,12,'CTR',9,1,1),
 (9,5,1,'CTR',10,1,1),
 (9,5,2,'CTR',10,1,1),
 (9,5,4,'CTR',20,1,1),
 (9,5,5,'CTR',10,1,1),
 (9,5,7,'CTR',10,1,1),
 (9,5,8,'CTR',10,1,1),
 (9,5,13,'CTR',10,1,1),
 (9,6,1,'CTR',10,1,1),
 (9,6,2,'CTR',10,1,1),
 (9,6,4,'CTR',20,1,1),
 (9,6,5,'CTR',10,1,1),
 (9,6,7,'CTR',10,1,1),
 (9,6,8,'CTR',10,1,1),
 (9,6,12,'CTR',9,1,1),
 (9,6,13,'CTR',10,1,1),
 (9,7,1,'CTR',10,1,1),
 (9,7,2,'CTR',10,1,1),
 (9,7,4,'CTR',20,1,1),
 (9,7,5,'CTR',10,1,1),
 (9,7,7,'CTR',10,1,1),
 (9,7,8,'CTR',10,1,1),
 (9,7,13,'CTR',10,1,1),
 (9,8,1,'CTR',10,1,1),
 (9,8,2,'CTR',10,1,1),
 (9,8,4,'CTR',20,1,1),
 (9,8,5,'CTR',10,1,1),
 (9,8,7,'CTR',10,1,1),
 (9,8,8,'CTR',10,1,1),
 (9,8,13,'CTR',10,1,1),
 (9,9,1,'CTR',10,1,1),
 (9,9,2,'CTR',10,1,1),
 (9,9,4,'CTR',10,1,1),
 (9,9,5,'CTR',11,1,1),
 (9,9,7,'CTR',10,1,1),
 (9,9,8,'CTR',10,1,1),
 (9,9,9,'CTR',10,1,1),
 (9,9,10,'CTR',10,1,1),
 (9,9,13,'CTR',10,1,1),
 (10,4,1,'CPC',11,1,1),
 (10,4,5,'CPC',11,1,1),
 (10,4,6,'CPC',11,1,1),
 (10,5,1,'CPC',11,1,1),
 (10,5,2,'CPC',11,1,1),
 (10,5,3,'CPC',11,1,1),
 (10,5,4,'CPC',21,1,1),
 (10,5,5,'CPC',11,1,1),
 (10,5,6,'CPC',11,1,1),
 (10,5,7,'CPC',11,1,1),
 (10,5,8,'CPC',11,1,1),
 (10,5,13,'CPC',11,1,1),
 (10,6,1,'CPC',11,1,1),
 (10,6,2,'CPC',11,1,1),
 (10,6,3,'CPC',11,1,1),
 (10,6,4,'CPC',21,1,1),
 (10,6,5,'CPC',11,1,1),
 (10,6,6,'CPC',11,1,1),
 (10,6,7,'CPC',11,1,1),
 (10,6,8,'CPC',11,1,1),
 (10,6,13,'CPC',11,1,1),
 (10,7,1,'CPC',11,1,1),
 (10,7,2,'CPC',11,1,1),
 (10,7,3,'CPC',11,1,1),
 (10,7,4,'CPC',21,1,1),
 (10,7,5,'CPC',11,1,1),
 (10,7,6,'CPC',11,1,1),
 (10,7,7,'CPC',11,1,1),
 (10,7,8,'CPC',11,1,1),
 (10,7,13,'CPC',11,1,1),
 (10,8,1,'CPC',11,1,1),
 (10,8,2,'CPC',11,1,1),
 (10,8,3,'CPC',11,1,1),
 (10,8,4,'CPC',21,1,1),
 (10,8,5,'CPC',11,1,1),
 (10,8,6,'CPC',11,1,1),
 (10,8,7,'CPC',11,1,1),
 (10,8,8,'CPC',11,1,1),
 (10,8,13,'CPC',11,1,1),
 (11,4,1,'Conversions',12,1,1),
 (11,4,4,'Conversions',22,1,1),
 (11,4,5,'Conversions',12,1,1),
 (11,4,6,'Conversions',12,1,1),
 (11,4,7,'Conversions',12,1,1),
 (11,4,8,'Conversions',12,1,1),
 (11,4,12,'Conversions',11,1,1),
 (11,4,13,'Conversions',12,1,1),
 (11,5,1,'Conversions',12,1,1),
 (11,5,2,'Conversions',12,1,1),
 (11,5,3,'Conversions',12,1,1),
 (11,5,4,'Conversions',22,1,1),
 (11,5,5,'Conversions',12,1,1),
 (11,5,6,'Conversions',12,1,1),
 (11,5,7,'Conversions',12,1,1),
 (11,5,8,'Conversions',12,1,1),
 (11,5,13,'Conversions',12,1,1),
 (11,6,1,'Conversions',12,1,1),
 (11,6,2,'Conversions',12,1,1),
 (11,6,3,'Conversions',12,1,1),
 (11,6,4,'Conversions',25,1,1),
 (11,6,5,'Conversions',12,1,1),
 (11,6,6,'Conversions',12,1,1),
 (11,6,7,'Conversions',12,1,1),
 (11,6,8,'Conversions',12,1,1),
 (11,6,12,'Conversions',11,1,1),
 (11,6,13,'Conversions',12,1,1),
 (11,7,1,'Conversions',12,1,1),
 (11,7,2,'Conversions',12,1,1),
 (11,7,3,'Conversions',12,1,1),
 (11,7,4,'Conversions',22,1,1),
 (11,7,5,'Conversions',12,1,1),
 (11,7,6,'Conversions',12,1,1),
 (11,7,7,'Conversions',12,1,1),
 (11,7,8,'Conversions',12,1,1),
 (11,7,13,'Conversions',12,1,1),
 (11,8,1,'Conversions',12,1,1),
 (11,8,2,'Conversions',12,1,1),
 (11,8,3,'Conversions',12,1,1),
 (11,8,4,'Conversions',22,1,1),
 (11,8,5,'Conversions',12,1,1),
 (11,8,6,'Conversions',12,1,1),
 (11,8,7,'Conversions',12,1,1),
 (11,8,8,'Conversions',12,1,1),
 (11,8,13,'Conversions',12,1,1),
 (11,9,1,'Conversions',12,1,1),
 (11,9,2,'Conversions',12,1,1),
 (11,9,3,'Conversions',12,1,1),
 (11,9,4,'Conversions',12,1,1),
 (11,9,5,'Conversions',13,1,1),
 (11,9,6,'Conversions',13,1,1),
 (11,9,7,'Conversions',12,1,1),
 (11,9,8,'Conversions',12,1,1),
 (11,9,9,'Conversions',12,1,1),
 (11,9,10,'Conversions',12,1,1),
 (11,9,13,'Conversions',12,1,1),
 (12,4,1,'CR',13,1,1),
 (12,4,4,'CR',23,1,1),
 (12,4,5,'CR',13,1,1),
 (12,4,6,'CR',13,1,1),
 (12,4,7,'CR',13,1,1),
 (12,4,8,'CR',13,1,1),
 (12,4,12,'CR',12,1,1),
 (12,4,13,'CR',13,1,1),
 (12,5,1,'CR',13,1,1),
 (12,5,2,'CR',13,1,1),
 (12,5,3,'CR',13,1,1),
 (12,5,4,'CR',23,1,1),
 (12,5,5,'CR',13,1,1),
 (12,5,6,'CR',13,1,1),
 (12,5,7,'CR',13,1,1),
 (12,5,8,'CR',13,1,1),
 (12,5,13,'CR',13,1,1),
 (12,6,1,'CR',13,1,1),
 (12,6,2,'CR',13,1,1),
 (12,6,3,'CR',13,1,1),
 (12,6,4,'CR',26,1,1),
 (12,6,5,'CR',13,1,1),
 (12,6,6,'CR',13,1,1),
 (12,6,7,'CR',13,1,1),
 (12,6,8,'CR',13,1,1),
 (12,6,12,'CR',12,1,1),
 (12,6,13,'CR',13,1,1),
 (12,7,1,'CR',13,1,1),
 (12,7,2,'CR',13,1,1),
 (12,7,3,'CR',13,1,1),
 (12,7,4,'CR',23,1,1),
 (12,7,5,'CR',13,1,1),
 (12,7,6,'CR',13,1,1),
 (12,7,7,'CR',13,1,1),
 (12,7,8,'CR',13,1,1),
 (12,7,13,'CR',13,1,1),
 (12,8,1,'CR',13,1,1),
 (12,8,2,'CR',13,1,1),
 (12,8,3,'CR',13,1,1),
 (12,8,4,'CR',23,1,1),
 (12,8,5,'CR',13,1,1),
 (12,8,6,'CR',13,1,1),
 (12,8,7,'CR',13,1,1),
 (12,8,8,'CR',13,1,1),
 (12,8,13,'CR',13,1,1),
 (12,9,1,'CR',13,1,1),
 (12,9,2,'CR',13,1,1),
 (12,9,3,'CR',13,1,1),
 (12,9,4,'CR',13,1,1),
 (12,9,5,'CR',14,1,1),
 (12,9,6,'CR',14,1,1),
 (12,9,7,'CR',13,1,1),
 (12,9,8,'CR',13,1,1),
 (12,9,9,'CR',13,1,1),
 (12,9,10,'CR',13,1,1),
 (12,9,13,'CR',13,1,1),
 (13,4,1,'Revenue',15,1,1),
 (13,4,4,'Revenue',27,1,1),
 (13,4,5,'Revenue',17,1,1),
 (13,4,6,'Revenue',15,1,1),
 (13,4,7,'Revenue',15,1,1),
 (13,4,8,'Revenue',15,1,1),
 (13,4,9,'Revenue',14,1,1),
 (13,4,10,'Revenue',8,1,1),
 (13,4,12,'Revenue',14,1,1),
 (13,4,13,'Revenue',15,1,1),
 (13,5,1,'Revenue',15,1,1),
 (13,5,2,'Revenue',15,1,1),
 (13,5,3,'Revenue',15,1,1),
 (13,5,4,'Revenue',27,1,1),
 (13,5,5,'Revenue',17,1,1),
 (13,5,6,'Revenue',15,1,1),
 (13,5,7,'Revenue',15,1,1),
 (13,5,8,'Revenue',15,1,1),
 (13,5,9,'Revenue',14,1,1),
 (13,5,10,'Revenue',14,1,1),
 (13,5,13,'Revenue',15,1,1),
 (13,6,1,'Revenue',15,1,1),
 (13,6,2,'Revenue',15,1,1),
 (13,6,3,'Revenue',15,1,1),
 (13,6,4,'Revenue',30,1,1),
 (13,6,5,'Revenue',17,1,1),
 (13,6,6,'Revenue',15,1,1),
 (13,6,7,'Revenue',15,1,1),
 (13,6,8,'Revenue',15,1,1),
 (13,6,9,'Revenue',14,1,1),
 (13,6,10,'Revenue',14,1,1),
 (13,6,12,'Revenue',14,1,1),
 (13,6,13,'Revenue',15,1,1),
 (13,7,1,'Revenue',15,1,1),
 (13,7,2,'Revenue',15,1,1),
 (13,7,3,'Revenue',15,1,1),
 (13,7,4,'Revenue',27,1,1),
 (13,7,5,'Revenue',17,1,1),
 (13,7,6,'Revenue',15,1,1),
 (13,7,7,'Revenue',15,1,1),
 (13,7,8,'Revenue',15,1,1),
 (13,7,9,'Revenue',14,1,1),
 (13,7,10,'Revenue',14,1,1),
 (13,7,13,'Revenue',15,1,1),
 (13,8,1,'Revenue',15,1,1),
 (13,8,2,'Revenue',15,1,1),
 (13,8,3,'Revenue',15,1,1),
 (13,8,4,'Revenue',27,1,1),
 (13,8,5,'Revenue',17,1,1),
 (13,8,6,'Revenue',15,1,1),
 (13,8,7,'Revenue',15,1,1),
 (13,8,8,'Revenue',15,1,1),
 (13,8,9,'Revenue',14,1,1),
 (13,8,10,'Revenue',14,1,1),
 (13,8,13,'Revenue',15,1,1),
 (13,9,1,'Revenue',15,1,1),
 (13,9,2,'Revenue',15,1,1),
 (13,9,3,'Revenue',15,1,1),
 (13,9,4,'Revenue',17,1,1),
 (13,9,5,'Revenue',18,1,1),
 (13,9,6,'Revenue',16,1,1),
 (13,9,7,'Revenue',15,1,1),
 (13,9,8,'Revenue',15,1,1),
 (13,9,9,'Revenue',15,1,1),
 (13,9,10,'Revenue',15,1,1),
 (13,9,13,'Revenue',15,1,1),
 (14,4,1,'EPV',16,1,1),
 (14,4,4,'EPV',28,1,1),
 (14,4,5,'EPV',18,1,1),
 (14,4,7,'EPV',16,1,1),
 (14,4,8,'EPV',16,1,1),
 (14,4,9,'EPV',15,1,1),
 (14,4,13,'EPV',16,1,1),
 (14,5,1,'EPV',16,1,1),
 (14,5,2,'EPV',16,1,1),
 (14,5,3,'EPV',16,1,1),
 (14,5,4,'EPV',28,1,1),
 (14,5,5,'EPV',18,1,1),
 (14,5,7,'EPV',16,1,1),
 (14,5,8,'EPV',16,1,1),
 (14,5,9,'EPV',15,1,1),
 (14,5,10,'EPV',15,1,1),
 (14,5,13,'EPV',16,1,1),
 (14,6,1,'EPV',16,1,1),
 (14,6,2,'EPV',16,1,1),
 (14,6,3,'EPV',16,1,1),
 (14,6,4,'EPV',31,1,1),
 (14,6,5,'EPV',18,1,1),
 (14,6,7,'EPV',16,1,1),
 (14,6,8,'EPV',16,1,1),
 (14,6,9,'EPV',15,1,1),
 (14,6,10,'EPV',15,1,1),
 (14,6,13,'EPV',16,1,1),
 (14,7,1,'EPV',16,1,1),
 (14,7,2,'EPV',16,1,1),
 (14,7,3,'EPV',16,1,1),
 (14,7,4,'EPV',28,1,1),
 (14,7,5,'EPV',18,1,1),
 (14,7,7,'EPV',16,1,1),
 (14,7,8,'EPV',16,1,1),
 (14,7,9,'EPV',15,1,1),
 (14,7,10,'EPV',15,1,1),
 (14,7,13,'EPV',16,1,1),
 (14,8,1,'EPV',16,1,1),
 (14,8,2,'EPV',16,1,1),
 (14,8,3,'EPV',16,1,1),
 (14,8,4,'EPV',28,1,1),
 (14,8,5,'EPV',18,1,1),
 (14,8,7,'EPV',16,1,1),
 (14,8,8,'EPV',16,1,1),
 (14,8,9,'EPV',15,1,1),
 (14,8,10,'EPV',15,1,1),
 (14,8,13,'EPV',16,1,1),
 (15,4,1,'PPV',17,1,1),
 (15,4,4,'PPV',29,1,1),
 (15,4,5,'PPV',19,1,1),
 (15,4,7,'PPV',17,1,1),
 (15,4,8,'PPV',17,1,1),
 (15,4,9,'PPV',16,1,1),
 (15,4,13,'PPV',17,1,1),
 (15,5,1,'PPV',17,1,1),
 (15,5,2,'PPV',17,1,1),
 (15,5,3,'PPV',17,1,1),
 (15,5,4,'PPV',29,1,1),
 (15,5,5,'PPV',19,1,1),
 (15,5,7,'PPV',17,1,1),
 (15,5,8,'PPV',17,1,1),
 (15,5,9,'PPV',16,1,1),
 (15,5,10,'PPV',16,1,1),
 (15,5,13,'PPV',17,1,1),
 (15,6,1,'PPV',17,1,1),
 (15,6,2,'PPV',17,1,1),
 (15,6,3,'PPV',17,1,1),
 (15,6,4,'PPV',32,1,1),
 (15,6,5,'PPV',19,1,1),
 (15,6,7,'PPV',17,1,1),
 (15,6,8,'PPV',17,1,1),
 (15,6,9,'PPV',16,1,1),
 (15,6,10,'PPV',16,1,1),
 (15,6,13,'PPV',17,1,1),
 (15,7,1,'PPV',17,1,1),
 (15,7,2,'PPV',17,1,1),
 (15,7,3,'PPV',17,1,1),
 (15,7,4,'PPV',29,1,1),
 (15,7,5,'PPV',19,1,1),
 (15,7,7,'PPV',17,1,1),
 (15,7,8,'PPV',17,1,1),
 (15,7,9,'PPV',16,1,1),
 (15,7,10,'PPV',16,1,1),
 (15,7,13,'PPV',17,1,1),
 (15,8,1,'PPV',17,1,1),
 (15,8,2,'PPV',17,1,1),
 (15,8,3,'PPV',17,1,1),
 (15,8,4,'PPV',29,1,1),
 (15,8,5,'PPV',19,1,1),
 (15,8,7,'PPV',17,1,1),
 (15,8,8,'PPV',17,1,1),
 (15,8,9,'PPV',16,1,1),
 (15,8,10,'PPV',16,1,1),
 (15,8,13,'PPV',17,1,1),
 (16,4,1,'eCPM',19,1,1),
 (16,4,4,'eCPM',31,1,1),
 (16,4,5,'eCPM',21,1,1),
 (16,4,7,'eCPM',19,1,1),
 (16,4,8,'eCPM',19,1,1),
 (16,4,13,'eCPM',19,1,1),
 (16,5,1,'eCPM',19,1,1),
 (16,5,2,'eCPM',19,1,1),
 (16,5,3,'eCPM',19,1,1),
 (16,5,4,'eCPM',31,1,1),
 (16,5,5,'eCPM',21,1,1),
 (16,5,7,'eCPM',19,1,1),
 (16,5,8,'eCPM',19,1,1),
 (16,5,13,'eCPM',19,1,1),
 (16,6,1,'eCPM',19,1,1),
 (16,6,2,'eCPM',19,1,1),
 (16,6,3,'eCPM',19,1,1),
 (16,6,4,'eCPM',34,1,1),
 (16,6,5,'eCPM',21,1,1),
 (16,6,7,'eCPM',19,1,1),
 (16,6,8,'eCPM',19,1,1),
 (16,6,13,'eCPM',19,1,1),
 (16,7,1,'eCPM',19,1,1),
 (16,7,2,'eCPM',19,1,1),
 (16,7,3,'eCPM',19,1,1),
 (16,7,4,'eCPM',31,1,1),
 (16,7,5,'eCPM',21,1,1),
 (16,7,7,'eCPM',19,1,1),
 (16,7,8,'eCPM',19,1,1),
 (16,7,13,'eCPM',19,1,1),
 (16,8,1,'eCPM',19,1,1),
 (16,8,2,'eCPM',19,1,1),
 (16,8,3,'eCPM',19,1,1),
 (16,8,4,'eCPM',31,1,1),
 (16,8,5,'eCPM',21,1,1),
 (16,8,7,'eCPM',19,1,1),
 (16,8,8,'eCPM',19,1,1),
 (16,8,13,'eCPM',19,1,1),
 (17,4,1,'P/L',18,1,1),
 (17,4,4,'P/L',30,1,1),
 (17,4,5,'P/L',20,1,1),
 (17,4,6,'P/L',18,1,1),
 (17,4,7,'P/L',18,1,1),
 (17,4,8,'P/L',18,1,1),
 (17,4,9,'P/L',17,1,1),
 (17,4,10,'P/L',9,1,1),
 (17,4,13,'P/L',18,1,1),
 (17,5,1,'P/L',18,1,1),
 (17,5,2,'P/L',18,1,1),
 (17,5,3,'P/L',18,1,1),
 (17,5,4,'P/L',30,1,1),
 (17,5,5,'P/L',20,1,1),
 (17,5,6,'P/L',18,1,1),
 (17,5,7,'P/L',18,1,1),
 (17,5,8,'P/L',18,1,1),
 (17,5,9,'P/L',17,1,1),
 (17,5,10,'P/L',17,1,1),
 (17,5,13,'P/L',18,1,1),
 (17,6,1,'P/L',18,1,1),
 (17,6,2,'P/L',18,1,1),
 (17,6,3,'P/L',18,1,1),
 (17,6,4,'P/L',33,1,1),
 (17,6,5,'P/L',20,1,1),
 (17,6,6,'P/L',18,1,1),
 (17,6,7,'P/L',18,1,1),
 (17,6,8,'P/L',18,1,1),
 (17,6,9,'P/L',17,1,1),
 (17,6,10,'P/L',17,1,1),
 (17,6,13,'P/L',18,1,1),
 (17,7,1,'P/L',18,1,1),
 (17,7,2,'P/L',18,1,1),
 (17,7,3,'P/L',18,1,1),
 (17,7,4,'P/L',30,1,1),
 (17,7,5,'P/L',20,1,1),
 (17,7,6,'P/L',18,1,1),
 (17,7,7,'P/L',18,1,1),
 (17,7,8,'P/L',18,1,1),
 (17,7,9,'P/L',17,1,1),
 (17,7,10,'P/L',17,1,1),
 (17,7,13,'P/L',18,1,1),
 (17,8,1,'P/L',18,1,1),
 (17,8,2,'P/L',18,1,1),
 (17,8,3,'P/L',18,1,1),
 (17,8,4,'P/L',30,1,1),
 (17,8,5,'P/L',20,1,1),
 (17,8,6,'P/L',18,1,1),
 (17,8,7,'P/L',18,1,1),
 (17,8,8,'P/L',18,1,1),
 (17,8,9,'P/L',17,1,1),
 (17,8,10,'P/L',17,1,1),
 (17,8,13,'P/L',18,1,1),
 (18,4,1,'ROI',20,1,1),
 (18,4,4,'ROI',32,1,1),
 (18,4,5,'ROI',22,1,1),
 (18,4,6,'ROI',20,1,1),
 (18,4,7,'ROI',20,1,1),
 (18,4,8,'ROI',20,1,1),
 (18,4,9,'ROI',19,1,1),
 (18,4,10,'ROI',10,1,1),
 (18,4,13,'ROI',20,1,1),
 (18,5,1,'ROI',20,1,1),
 (18,5,2,'ROI',20,1,1),
 (18,5,3,'ROI',20,1,1),
 (18,5,4,'ROI',32,1,1),
 (18,5,5,'ROI',22,1,1),
 (18,5,6,'ROI',20,1,1),
 (18,5,7,'ROI',20,1,1),
 (18,5,8,'ROI',20,1,1),
 (18,5,9,'ROI',19,1,1),
 (18,5,10,'ROI',19,1,1),
 (18,5,13,'ROI',20,1,1),
 (18,6,1,'ROI',20,1,1),
 (18,6,2,'ROI',20,1,1),
 (18,6,3,'ROI',20,1,1),
 (18,6,4,'ROI',35,1,1),
 (18,6,5,'ROI',22,1,1),
 (18,6,6,'ROI',20,1,1),
 (18,6,7,'ROI',20,1,1),
 (18,6,8,'ROI',20,1,1),
 (18,6,9,'ROI',19,1,1),
 (18,6,10,'ROI',19,1,1),
 (18,6,13,'ROI',20,1,1),
 (18,7,1,'ROI',20,1,1),
 (18,7,2,'ROI',20,1,1),
 (18,7,3,'ROI',20,1,1),
 (18,7,4,'ROI',32,1,1),
 (18,7,5,'ROI',22,1,1),
 (18,7,6,'ROI',20,1,1),
 (18,7,7,'ROI',20,1,1),
 (18,7,8,'ROI',20,1,1),
 (18,7,9,'ROI',19,1,1),
 (18,7,10,'ROI',19,1,1),
 (18,7,13,'ROI',20,1,1),
 (18,8,1,'ROI',20,1,1),
 (18,8,2,'ROI',20,1,1),
 (18,8,3,'ROI',20,1,1),
 (18,8,4,'ROI',32,1,1),
 (18,8,5,'ROI',22,1,1),
 (18,8,6,'ROI',20,1,1),
 (18,8,7,'ROI',20,1,1),
 (18,8,8,'ROI',20,1,1),
 (18,8,9,'ROI',19,1,1),
 (18,8,10,'ROI',19,1,1),
 (18,8,13,'ROI',20,1,1),
 (19,4,2,'Engage%',6,1,1),
 (19,4,4,'Engage%',16,1,1),
 (19,4,5,'Engage%',6,1,1),
 (19,4,7,'Engage%',6,1,1),
 (19,4,8,'Engage%',6,1,1),
 (19,4,13,'Engage%',6,1,1),
 (19,5,2,'Engage%',6,1,1),
 (19,5,4,'Engage%',16,1,1),
 (19,5,5,'Engage%',6,1,1),
 (19,5,7,'Engage%',6,1,1),
 (19,5,8,'Engage%',6,1,1),
 (19,5,13,'Engage%',6,1,1),
 (19,6,2,'Engage%',6,1,1),
 (19,6,4,'Engage%',16,1,1),
 (19,6,5,'Engage%',6,1,1),
 (19,6,7,'Engage%',6,1,1),
 (19,6,8,'Engage%',6,1,1),
 (19,6,13,'Engage%',6,1,1),
 (19,7,2,'Engage%',6,1,1),
 (19,7,4,'Engage%',16,1,1),
 (19,7,5,'Engage%',6,1,1),
 (19,7,7,'Engage%',6,1,1),
 (19,7,8,'Engage%',6,1,1),
 (19,7,13,'Engage%',6,1,1),
 (19,8,2,'Engage%',6,1,1),
 (19,8,4,'Engage%',16,1,1),
 (19,8,5,'Engage%',6,1,1),
 (19,8,7,'Engage%',6,1,1),
 (19,8,8,'Engage%',6,1,1),
 (19,8,13,'Engage%',6,1,1),
 (19,9,2,'Engage%',6,1,1),
 (19,9,5,'Engage%',7,1,1),
 (19,9,7,'Engage%',6,1,1),
 (19,9,8,'Engage%',6,1,1),
 (19,9,13,'Engage%',6,1,1),
 (20,4,7,' ',1,1,1),
 (20,4,8,' ',1,1,1),
 (20,4,13,' ',1,1,1),
 (20,5,7,' ',1,1,1),
 (20,5,8,' ',1,1,1),
 (20,5,13,' ',1,1,1),
 (20,6,7,' ',1,1,1),
 (20,6,8,' ',1,1,1),
 (20,6,13,' ',1,1,1),
 (20,7,7,' ',1,1,1),
 (20,7,8,' ',1,1,1),
 (20,7,13,' ',1,1,1),
 (20,8,7,' ',1,1,1),
 (20,8,8,' ',1,1,1),
 (20,8,13,' ',1,1,1),
 (20,9,7,' ',1,1,1),
 (20,9,8,' ',1,1,1),
 (20,9,13,' ',1,1,1),
 (21,4,4,'Offer',25,0,0),
 (21,4,5,'Offer',15,0,0),
 (21,5,4,'Offer',25,0,1),
 (21,5,5,'Offer',15,0,0),
 (21,6,4,'Offer',28,0,0),
 (21,6,5,'Offer',15,0,0),
 (21,7,4,'Offer',25,0,1),
 (21,7,5,'Offer',15,0,0),
 (21,8,4,'Offer',25,0,0),
 (21,8,5,'Offer',15,0,0),
 (21,9,4,'Offer',15,0,0),
 (21,9,5,'Offer',16,0,0),
 (22,4,4,'Offer Url',26,0,0),
 (22,4,5,'Offer Url',16,0,0),
 (22,5,4,'Offer Url',26,0,0),
 (22,5,5,'Offer Url',16,0,0),
 (22,6,4,'Offer Url',29,0,0),
 (22,6,5,'Offer Url',16,0,0),
 (22,7,4,'Offer Url',26,0,0),
 (22,7,5,'Offer Url',16,0,0),
 (22,8,4,'Offer Url',26,0,0),
 (22,8,5,'Offer Url',16,0,0),
 (22,9,4,'Offer Url',16,0,0),
 (22,9,5,'Offer Url',17,0,0),
 (25,9,1,'EPS',19,1,1),
 (25,9,4,'EPS',19,1,1),
 (25,9,9,'EPS',19,1,1),
 (25,9,10,'EPS',19,1,1),
 (26,6,11,'Embed',6,1,1),
 (27,6,11,'Embed%',7,1,1),
 (28,6,11,'Popup',8,1,1),
 (29,6,11,'Popup%',9,1,1),
 (30,6,11,'Exit',10,1,1),
 (31,6,11,'Exit%',11,1,1),
 (32,4,5,'ID',1,1,1),
 (32,4,6,'ID',1,1,1),
 (32,5,5,'ID',1,1,1),
 (32,5,6,'ID',1,1,1),
 (32,6,5,'ID',1,1,1),
 (32,6,6,'ID',1,1,1),
 (32,6,11,'ID',1,1,1),
 (32,7,5,'ID',1,1,1),
 (32,7,6,'ID',1,1,1),
 (32,8,5,'ID',1,1,1),
 (32,8,6,'ID',1,1,1),
 (32,9,5,'ID',1,1,1),
 (32,9,6,'ID',1,1,1),
 (33,9,1,'Email',2,1,1),
 (33,9,4,'Email',2,1,1),
 (33,9,5,'Email',2,1,1),
 (33,9,6,'Email',2,1,1),
 (34,4,2,'Subscribers',9,1,1),
 (34,4,4,'Subscribers',19,1,1),
 (34,4,5,'Subscribers',9,1,1),
 (34,4,7,'Subscribers',9,1,1),
 (34,4,8,'Subscribers',9,1,1),
 (34,4,10,'Subscribers',12,1,1),
 (34,4,13,'Subscribers',9,1,1),
 (34,6,4,'Subscribers',22,1,1),
 (34,6,11,'Subscribers',12,1,1),
 (35,4,2,'SR',10,1,1),
 (35,4,4,'SR',20,1,1),
 (35,4,5,'SR',10,1,1),
 (35,4,7,'SR',10,1,1),
 (35,4,8,'SR',10,1,1),
 (35,4,10,'SR',13,1,1),
 (35,4,13,'SR',10,1,1),
 (35,6,4,'SR',23,1,1),
 (35,6,11,'SR',13,1,1),
 (36,4,2,'CPSUB',11,1,1),
 (36,4,4,'CPSUB',21,1,1),
 (36,4,5,'CPSUB',11,1,1),
 (36,4,7,'CPSUB',11,1,1),
 (36,4,8,'CPSUB',11,1,1),
 (36,4,10,'CPSUB',14,1,1),
 (36,4,13,'CPSUB',11,1,1),
 (36,6,4,'CPSUB',24,1,1),
 (37,4,4,'Extra1',5,1,1),
 (37,5,4,'Extra1',5,1,1),
 (37,6,4,'Extra1',5,1,1),
 (37,7,4,'Extra1',5,1,1),
 (37,8,4,'Extra1',5,1,1),
 (38,4,4,'Extra2',6,1,1),
 (38,5,4,'Extra2',6,1,1),
 (38,6,4,'Extra2',6,1,1),
 (38,7,4,'Extra2',6,1,1),
 (38,8,4,'Extra2',6,1,1),
 (39,4,4,'Extra3',7,1,1),
 (39,5,4,'Extra3',7,1,1),
 (39,6,4,'Extra3',7,1,1),
 (39,7,4,'Extra3',7,1,1),
 (39,8,4,'Extra3',7,1,1),
 (40,4,4,'Extra4',8,1,1),
 (40,5,4,'Extra4',8,1,1),
 (40,6,4,'Extra4',8,1,1),
 (40,7,4,'Extra4',8,1,1),
 (40,8,4,'Extra4',8,1,1),
 (41,4,4,'Extra5',9,1,1),
 (41,5,4,'Extra5',9,1,1),
 (41,6,4,'Extra5',9,1,1),
 (41,7,4,'Extra5',9,1,1),
 (41,8,4,'Extra5',9,1,1),
 (42,4,4,'Extra6',10,1,1),
 (42,5,4,'Extra6',10,1,1),
 (42,6,4,'Extra6',10,1,1),
 (42,7,4,'Extra6',10,1,1),
 (42,8,4,'Extra6',10,1,1),
 (43,4,4,'Extra7',11,1,1),
 (43,5,4,'Extra7',11,1,1),
 (43,6,4,'Extra7',11,1,1),
 (43,7,4,'Extra7',11,1,1),
 (43,8,4,'Extra7',11,1,1),
 (44,4,4,'Extra8',12,1,1),
 (44,5,4,'Extra8',12,1,1),
 (44,6,4,'Extra8',12,1,1),
 (44,7,4,'Extra8',12,1,1),
 (44,8,4,'Extra8',12,1,1),
 (45,4,4,'Extra9',13,1,1),
 (45,5,4,'Extra9',13,1,1),
 (45,6,4,'Extra9',13,1,1),
 (45,7,4,'Extra9',13,1,1),
 (45,8,4,'Extra9',13,1,1),
 (46,4,4,'Extra10',14,1,1),
 (46,5,4,'Extra10',14,1,1),
 (46,6,4,'Extra10',14,1,1),
 (46,7,4,'Extra10',14,1,1),
 (46,8,4,'Extra10',14,1,1),
 (47,4,1,'CPA',14,1,1),
 (47,4,4,'CPA',24,1,1),
 (47,4,5,'CPA',14,1,1),
 (47,4,6,'CPA',14,1,1),
 (47,4,7,'CPA',14,1,1),
 (47,4,8,'CPA',14,1,1),
 (47,4,12,'CPA',13,1,1),
 (47,4,13,'CPA',14,1,1),
 (47,5,1,'CPA',14,1,1),
 (47,5,2,'CPA',14,1,1),
 (47,5,3,'CPA',14,1,1),
 (47,5,4,'CPA',24,1,1),
 (47,5,5,'CPA',14,1,1),
 (47,5,6,'CPA',14,1,1),
 (47,5,7,'CPA',14,1,1),
 (47,5,8,'CPA',14,1,1),
 (47,5,13,'CPA',14,1,1),
 (47,6,1,'CPA',14,1,1),
 (47,6,2,'CPA',14,1,1),
 (47,6,3,'CPA',14,1,1),
 (47,6,4,'CPA',27,1,1),
 (47,6,5,'CPA',14,1,1),
 (47,6,6,'CPA',14,1,1),
 (47,6,7,'CPA',14,1,1),
 (47,6,8,'CPA',14,1,1),
 (47,6,12,'CPA',13,1,1),
 (47,6,13,'CPA',14,1,1),
 (47,7,1,'CPA',14,1,1),
 (47,7,2,'CPA',14,1,1),
 (47,7,3,'CPA',14,1,1),
 (47,7,4,'CPA',24,1,1),
 (47,7,5,'CPA',14,1,1),
 (47,7,6,'CPA',14,1,1),
 (47,7,7,'CPA',14,1,1),
 (47,7,8,'CPA',14,1,1),
 (47,7,13,'CPA',14,1,1),
 (47,8,1,'CPA',14,1,1),
 (47,8,2,'CPA',14,1,1),
 (47,8,3,'CPA',14,1,1),
 (47,8,4,'CPA',24,1,1),
 (47,8,5,'CPA',14,1,1),
 (47,8,6,'CPA',14,1,1),
 (47,8,7,'CPA',14,1,1),
 (47,8,8,'CPA',14,1,1),
 (47,8,13,'CPA',14,1,1),
 (47,9,1,'CPA',14,1,1),
 (47,9,2,'CPA',14,1,1),
 (47,9,3,'CPA',14,1,1),
 (47,9,4,'CPA',14,1,1),
 (47,9,5,'CPA',15,1,1),
 (47,9,6,'CPA',15,1,1),
 (47,9,7,'CPA',14,1,1),
 (47,9,8,'CPA',14,1,1),
 (47,9,9,'CPA',14,1,1),
 (47,9,10,'CPA',14,1,1),
 (47,9,13,'CPA',14,1,1);
/*!40000 ALTER TABLE `columnstypes` ENABLE KEYS */;


ALTER TABLE `campaigns` ADD COLUMN `ExtraTokenName1` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ShareOffer`,
 ADD COLUMN `ExtraTokenUrl1` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName1`,
 ADD COLUMN `ExtraTokenParam1` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl1`,
 ADD COLUMN `ExtraTokenName2` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenParam1`,
 ADD COLUMN `ExtraTokenUrl2` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName2`,
 ADD COLUMN `ExtraTokenParam2` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl2`,
 ADD COLUMN `ExtraTokenName3` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenParam2`,
 ADD COLUMN `ExtraTokenUrl3` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName3`,
 ADD COLUMN `ExtraTokenParam3` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl3`,
 ADD COLUMN `ExtraTokenName4` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenParam3`,
 ADD COLUMN `ExtraTokenUrl4` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName4`,
 ADD COLUMN `ExtraTokenParam4` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl4`,
 ADD COLUMN `ExtraTokenName5` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenParam4`,
 ADD COLUMN `ExtraTokenUrl5` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName5`,
 ADD COLUMN `ExtraTokenParam5` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl5`,
 ADD COLUMN `ExtraTokenName6` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenParam5`,
 ADD COLUMN `ExtraTokenUrl6` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName6`,
 ADD COLUMN `ExtraTokenParam6` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl6`,
 ADD COLUMN `ExtraTokenName7` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenParam6`,
 ADD COLUMN `ExtraTokenUrl7` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName7`,
 ADD COLUMN `ExtraTokenParam7` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl7`,
 ADD COLUMN `ExtraTokenName8` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenParam7`,
 ADD COLUMN `ExtraTokenUrl8` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName8`,
 ADD COLUMN `ExtraTokenParam8` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl8`,
 ADD COLUMN `ExtraTokenName9` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenParam8`,
 ADD COLUMN `ExtraTokenUrl9` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName9`,
 ADD COLUMN `ExtraTokenParam9` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl9`,
 ADD COLUMN `ExtraTokenName10` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenParam9`,
 ADD COLUMN `ExtraTokenUrl10` VARCHAR(250) NOT NULL DEFAULT '' AFTER `ExtraTokenName10`,
 ADD COLUMN `ExtraTokenParam10` VARCHAR(100) NOT NULL DEFAULT '' AFTER `ExtraTokenUrl10`;


CREATE TABLE `clicksextra` (
  `ClickID` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `Extra1` VARCHAR(500) NOT NULL DEFAULT '',
  `Extra2` VARCHAR(500) NOT NULL DEFAULT '',
  `Extra3` VARCHAR(500) NOT NULL DEFAULT '',
  `Extra4` VARCHAR(500) NOT NULL DEFAULT '',
  `Extra5` VARCHAR(500) NOT NULL DEFAULT '',
  `Extra6` VARCHAR(500) NOT NULL DEFAULT '',
  `Extra7` VARCHAR(500) NOT NULL DEFAULT '',
  `Extra8` VARCHAR(500) NOT NULL DEFAULT '',
  `Extra9` VARCHAR(500) NOT NULL DEFAULT '',
  `Extra10` VARCHAR(500) NOT NULL DEFAULT '',
  PRIMARY KEY (`ClickID`)
)
ENGINE = InnoDB;

CREATE TABLE `clicksopt` (
  `ClickID` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `OptEmbedDate` DATETIME NULL ,
  `OptPopUpDate` DATETIME NULL ,
  `OptExitPopDate` DATETIME NULL ,
  PRIMARY KEY (`ClickID`) 
)
ENGINE = InnoDB;

insert into clicksopt(ClickID, OptEmbedDate, OptPopUpDate, OptExitPopDate)
select ClickID, OptEmbedDate, OptPopUpDate, OptExitPopDate
from clicks
where OptEmbedDate IS NOT NULL OR OptPopUpDate IS NOT NULL OR OptExitPopDate IS NOT NULL;


ALTER TABLE `destinations` ADD COLUMN `Inactive` TINYINT(1) NOT NULL DEFAULT 0 AFTER `CurrentSharePath`;


ALTER TABLE `campaigns` DROP COLUMN `OfferName`,
 DROP COLUMN `OfferUrl`,
 DROP COLUMN `Payout`,
 DROP COLUMN `AffiliateSourceID`;

ALTER TABLE `campaigns` ADD COLUMN `PassCookie` TINYINT(4) NOT NULL DEFAULT 0  AFTER `PassSubId` ;

ALTER TABLE `campaigns` ADD COLUMN `PassTargetOffer` TINYINT(4) NOT NULL DEFAULT 0  AFTER `PassTarget` ;

ALTER TABLE `campaigns` ADD COLUMN `RedirectType` TINYINT(3) UNSIGNED NOT NULL DEFAULT 2  AFTER `PassCookie` ;

ALTER TABLE `campaigns` ADD COLUMN `ExtraTokens` TINYINT(4) UNSIGNED NOT NULL DEFAULT 0  AFTER `ShareOffer` ;

ALTER TABLE `clicks` DROP COLUMN `VisitDate` , DROP COLUMN `OptEmbedDate` , DROP COLUMN `OptExitPopDate` , DROP COLUMN `OptPopUpDate` ;

ALTER TABLE `campaigns` 
ADD INDEX `idxCampaignTypeID` (`CampaignTypeID` ASC);

ALTER TABLE `clicks` 
ADD INDEX `idxCampaignID` (`CampaignID` ASC)
, ADD INDEX `idxDestinationID` (`DestinationID` ASC) 
, ADD INDEX `idxOfferID` (`OfferID` ASC)
, ADD INDEX `idxViewDate` (`ViewDate` ASC) ;

ALTER TABLE `columns` 
ADD INDEX `idxIsFixed` (`IsFixed` ASC) ;

ALTER TABLE `columnscharts` 
ADD INDEX `idxIsVisible` (`IsVisible` ASC) ;

ALTER TABLE `columnstypes` 
ADD INDEX `idxIsVisible` (`IsVisible` ASC) ;

ALTER TABLE `destinations` 
ADD INDEX `idxCampaignID` (`CampaignID` ASC)
, ADD INDEX `idxPathID` (`PathID` ASC)
, ADD INDEX `idxCampaignInactiveLevel` (`CampaignID` ASC, `Inactive` ASC, `Level` ASC) ;

ALTER TABLE `reports` 
ADD INDEX `idxCampaignID` (`CampaignID` ASC) ;

ALTER TABLE `reportdetailsgroup` 
ADD INDEX `idxReportID` (`ReportID` ASC) ;

ALTER TABLE `reportdetailscampaign` 
ADD INDEX `idxReportID` (`ReportID` ASC) ;

ALTER TABLE `subids` 
ADD UNIQUE INDEX `idxKeyword` (`Keyword` ASC)
, ADD UNIQUE INDEX `idxSubId` (`SubId` ASC) ;

insert into reporttypes(ReportTypeID,ReportTypeName)
values(13, 'Trends Days');
update reporttypes set ReportTypeName='Trends Day of Week' where ReportTypeID=8;

ALTER TABLE `reportdetailsgroup` ADD COLUMN `CPA` DOUBLE NOT NULL DEFAULT 0 AFTER `CR`;

ALTER TABLE `reportdetailscampaign` ADD COLUMN `CPA` DOUBLE NOT NULL DEFAULT 0 AFTER `CR`;

update reportdetailsgroup set CPA=Cost/Conversion where Conversion is not null and Conversion<>0;

update reportdetailscampaign set CPA=Cost/Conversion where Conversion is not null and Conversion<>0;

drop table `reportdetails`;

drop table `reportdetailsdestination`;

drop table `reportdetailsoffer`;

drop table `reportdetailstarget`;

ALTER TABLE `destinations` DROP COLUMN `TotalViews` ;


CREATE TABLE `config` (
  `Name` VARCHAR(100) NOT NULL ,
  `Value` VARCHAR(100) NOT NULL ,
  PRIMARY KEY (`Name`) );

insert into config(Name, Value) values('version','2.11');



update destinations set PathID=1
where PathID=0 and CampaignID in (select CampaignID from campaigns where CampaignTypeID=6);





/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
